/*
 * Decompiled with CFR 0.152.
 */
package forsedi.criptografia;

import forsedi.criptografia.Base64;
import forsedi.criptografia.Criptografia;
import forsedi.criptografia.excepcion.CriptografiaExcepcion;
import forsedi.criptografia.excepcion.SelladorExcepcion;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.ssl.PKCS8Key;

public class Sellador {
    private static Templates cache = null;
    private String rutallave;
    private char[] contrasenaLlave;

    public Sellador(String rutallave, String contrasenaLlave) {
        this(rutallave, contrasenaLlave.toCharArray());
    }

    public Sellador(String rutallave, char[] contrasenaLlave) {
        this.rutallave = rutallave;
        this.contrasenaLlave = contrasenaLlave;
    }

    public static String getSello(String cadenaOriginal, String rutaLlave, String passLlave, String semilla) throws SelladorExcepcion {
        String sello = "";
        try {
            Signature sign = Signature.getInstance("SHA256withRSA", "SunRsaSign");
            PrivateKey llavePrivada = Sellador.getLlave(rutaLlave, passLlave, semilla);
            sign.initSign(llavePrivada);
            sign.update(cadenaOriginal.getBytes("UTF-8"));
            sello = Base64.encodeBytes(sign.sign(), 8);
        }
        catch (UnsupportedEncodingException ex) {
            throw new SelladorExcepcion("No se encontro el Algoritmo: SHA1withRSA", "forsedi.criptografia.Sellador.getSello.NoSuchAlgorithmException.", ex);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SelladorExcepcion("No se encontro el Algoritmo: SHA1withRSA", "forsedi.criptografia.Sellador.getSello.NoSuchAlgorithmException.", nsae);
        }
        catch (NoSuchProviderException nspe) {
            throw new SelladorExcepcion("No se encontro el proveedor : SunRsaSign", "forsedi.criptografia.Sellador.getSello.NoSuchProviderException.", nspe);
        }
        catch (InvalidKeyException ike) {
            throw new SelladorExcepcion("Llave privada invalida", "forsedi.criptografia.Sellador.getSello.InvalidKeyException.", ike);
        }
        catch (SignatureException se) {
            throw new SelladorExcepcion("Error al sellar los datos", "forsedi.criptografia.Sellador.getSello.SignatureException.", se);
        }
        return sello;
    }

    public static PrivateKey getLlave(String rutaE, String passE, String semilla) throws SelladorExcepcion {
        PrivateKey pk = null;
        try {
            String passD;
            String rutaD;
            if (!semilla.equals("")) {
                rutaD = Criptografia.desencriptar(rutaE, semilla);
                passD = Criptografia.desencriptar(passE, semilla);
            } else {
                rutaD = rutaE;
                passD = passE;
            }
            FileInputStream archivo = new FileInputStream(rutaD);
            PKCS8Key pkcs = new PKCS8Key((InputStream)archivo, passD.toCharArray());
            pk = pkcs.getPrivateKey();
            archivo.close();
        }
        catch (FileNotFoundException fnfe) {
            throw new SelladorExcepcion("No se encontro el archivo de llave privada", "forsedi.criptografia.Sellador.getLlave.FileNotFoundException.", fnfe);
        }
        catch (GeneralSecurityException ges) {
            throw new SelladorExcepcion("Error la procesar la llave privada", "forsedi.criptografia.Sellador.getLlave.GeneralSecurityException.", ges);
        }
        catch (IOException ioe) {
            throw new SelladorExcepcion("Error al leer el archivo de llave privada", "forsedi.criptografia.Sellador.getLlave.IOException.", ioe);
        }
        catch (CriptografiaExcepcion ce) {
            throw new SelladorExcepcion("Error al desencriptar datos de ubicacion de la llave", "forsedi.criptografia.Sellador.getLlave.CriptografiaExcepcion.", ce);
        }
        return pk;
    }

    public String getSello(String cadenaOriginal) throws SelladorExcepcion {
        String sello = "";
        try {
            System.out.println("Obteniendo instancia de SHA1withRSA");
            Signature sign = Signature.getInstance("SHA256withRSA", "SunRsaSign");
            System.out.println("Instancia de SHA1withRSA obtenida");
            System.out.println("Obteniendo llavePrivada");
            PrivateKey llavePrivada = this.getLlave();
            System.out.println("llavePrivada obtenida");
            System.out.println("Obteniendo sello");
            sign.initSign(llavePrivada);
            sign.update(cadenaOriginal.getBytes("UTF-8"));
            System.out.println("Sello obtenida");
            sello = Base64.encodeBytes(sign.sign(), 8);
        }
        catch (UnsupportedEncodingException ex) {
            throw new SelladorExcepcion("No se encontro el Algoritmo: SHA1withRSA", "forsedi.criptografia.Sellador.getSello.NoSuchAlgorithmException.", ex);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SelladorExcepcion("No se encontro el Algoritmo: SHA1withRSA", "forsedi.criptografia.Sellador.getSello.NoSuchAlgorithmException.", nsae);
        }
        catch (NoSuchProviderException nspe) {
            throw new SelladorExcepcion("No se encontro el proveedor : SunRsaSign", "forsedi.criptografia.Sellador.getSello.NoSuchProviderException.", nspe);
        }
        catch (InvalidKeyException ike) {
            throw new SelladorExcepcion("Llave privada invalida", "forsedi.criptografia.Sellador.getSello.InvalidKeyException.", ike);
        }
        catch (SignatureException se) {
            throw new SelladorExcepcion("Error al sellar los datos", "forsedi.criptografia.Sellador.getSello.SignatureException.", se);
        }
        return sello;
    }

    public PrivateKey getLlave() throws SelladorExcepcion {
        PrivateKey pk = null;
        try {
            int nRead;
            System.out.println("Abriendo archivo de llavePrivada->" + this.rutallave);
            FileInputStream archivo = new FileInputStream(this.rutallave);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = archivo.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            System.out.println("Archivo de llave priavda abierto");
            System.out.println("Creando objeto PKCS8Key" + new Date());
            PKCS8Key pkcs = new PKCS8Key(buffer.toByteArray(), this.contrasenaLlave);
            System.out.println("Creando objeto PKCS8Key" + new Date());
            System.out.println("Obteniendo PrivateKey");
            pk = pkcs.getPrivateKey();
            System.out.println("PrivateKey obtenido");
            archivo.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            throw new SelladorExcepcion("No se encontro el archivo de llave privada", "forsedi.criptografia.Sellador.getLlave.FileNotFoundException.", fnfe);
        }
        catch (GeneralSecurityException ges) {
            ges.printStackTrace();
            throw new SelladorExcepcion("Error la procesar la llave privada", "forsedi.criptografia.Sellador.getLlave.GeneralSecurityException.", ges);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new SelladorExcepcion("Error al leer el archivo de llave privada", "forsedi.criptografia.Sellador.getLlave.IOException.", ioe);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pk;
    }

    public String getRutallave() {
        return this.rutallave;
    }

    public void setRutallave(String rutallave) {
        this.rutallave = rutallave;
    }

    public char[] getContrasenaLlave() {
        return this.contrasenaLlave;
    }

    public void setContrasenaLlave(char[] contrasenaLlave) {
        this.contrasenaLlave = contrasenaLlave;
    }

    public static String getSello(String cadenaOriginal, String rutaLlave, String semillaRuta, String passLlave, String semillaPass) throws SelladorExcepcion {
        String sello = "";
        try {
            Signature sign = Signature.getInstance("SHA256withRSA", "SunRsaSign");
            PrivateKey llavePrivada = Sellador.getLlave(rutaLlave, semillaRuta, passLlave, semillaPass);
            sign.initSign(llavePrivada);
            sign.update(cadenaOriginal.getBytes("UTF-8"));
            sello = Base64.encodeBytes(sign.sign(), 8);
        }
        catch (UnsupportedEncodingException ex) {
            throw new SelladorExcepcion("No se encontro el Algoritmo: SHA1withRSA", "forsedi.criptografia.Sellador.getSello.NoSuchAlgorithmException.", ex);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SelladorExcepcion("No se encontro el Algoritmo: SHA1withRSA", "forsedi.criptografia.Sellador.getSello.NoSuchAlgorithmException.", nsae);
        }
        catch (NoSuchProviderException nspe) {
            throw new SelladorExcepcion("No se encontro el proveedor : SunRsaSign", "forsedi.criptografia.Sellador.getSello.NoSuchProviderException.", nspe);
        }
        catch (InvalidKeyException ike) {
            throw new SelladorExcepcion("Llave privada invalida", "forsedi.criptografia.Sellador.getSello.InvalidKeyException.", ike);
        }
        catch (SignatureException se) {
            throw new SelladorExcepcion("Error al sellar los datos", "forsedi.criptografia.Sellador.getSello.SignatureException.", se);
        }
        return sello;
    }

    public static String getSello33(String cadenaOriginal, String rutaLlave, String semillaRuta, String passLlave, String semillaPass) throws SelladorExcepcion {
        String sello = "";
        try {
            Signature sign = Signature.getInstance("SHA256withRSA", "SunRsaSign");
            PrivateKey llavePrivada = Sellador.getLlave(rutaLlave, semillaRuta, passLlave, semillaPass);
            sign.initSign(llavePrivada);
            sign.update(cadenaOriginal.getBytes("UTF-8"));
            sello = Base64.encodeBytes(sign.sign(), 8);
        }
        catch (UnsupportedEncodingException ex) {
            throw new SelladorExcepcion("No se encontro el Algoritmo: SHA256withRSA", "forsedi.criptografia.Sellador.getSello.NoSuchAlgorithmException.", ex);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SelladorExcepcion("No se encontro el Algoritmo: SHA256withRSA", "forsedi.criptografia.Sellador.getSello.NoSuchAlgorithmException.", nsae);
        }
        catch (NoSuchProviderException nspe) {
            throw new SelladorExcepcion("No se encontro el proveedor : SunRsaSign", "forsedi.criptografia.Sellador.getSello.NoSuchProviderException.", nspe);
        }
        catch (InvalidKeyException ike) {
            throw new SelladorExcepcion("Llave privada invalida", "forsedi.criptografia.Sellador.getSello.InvalidKeyException.", ike);
        }
        catch (SignatureException se) {
            throw new SelladorExcepcion("Error al sellar los datos", "forsedi.criptografia.Sellador.getSello.SignatureException.", se);
        }
        return sello;
    }

    public static PrivateKey getLlave(String rutaE, String semillaRuta, String passE, String semillaPass) throws SelladorExcepcion {
        PrivateKey pk = null;
        try {
            String rutaD = semillaRuta != null && !semillaRuta.equals("") ? Criptografia.desencriptar(rutaE, semillaRuta) : rutaE;
            String passD = semillaPass != null && !semillaPass.equals("") ? Criptografia.desencriptar(passE, semillaPass) : passE;
            FileInputStream archivo = new FileInputStream(rutaD);
            PKCS8Key pkcs = new PKCS8Key((InputStream)archivo, passD.toCharArray());
            pk = pkcs.getPrivateKey();
            archivo.close();
        }
        catch (FileNotFoundException fnfe) {
            throw new SelladorExcepcion("No se encontro el archivo de llave privada", "forsedi.criptografia.Sellador.getLlave.FileNotFoundException.", fnfe);
        }
        catch (GeneralSecurityException ges) {
            throw new SelladorExcepcion("Error la procesar la llave privada", "forsedi.criptografia.Sellador.getLlave.GeneralSecurityException.", ges);
        }
        catch (IOException ioe) {
            throw new SelladorExcepcion("Error al leer el archivo de llave privada", "forsedi.criptografia.Sellador.getLlave.IOException.", ioe);
        }
        catch (CriptografiaExcepcion ce) {
            throw new SelladorExcepcion("Error al desencriptar datos de ubicacion de la llave", "forsedi.criptografia.Sellador.getLlave.CriptografiaExcepcion.", ce);
        }
        return pk;
    }

    public static String getCadenaOriginal33(String xml) {
        String cadena = "";
        try {
            StreamSource xmlSource = new StreamSource(new CharArrayReader(xml.toCharArray()));
            StringWriter strWriter = new StringWriter();
            StreamResult result = new StreamResult(strWriter);
            if (cache == null) {
                FileInputStream xslt = new FileInputStream("Configuracion\\XSL\\cadenaoriginal_3_3.xslt");
                StreamSource xsltSource = new StreamSource(xslt);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                cache = transformerFactory.newTemplates(xsltSource);
            }
            Transformer transformer = cache.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(xmlSource, result);
            cadena = strWriter.toString();
        }
        catch (Exception ex) {
            Logger.getLogger(Sellador.class.getName()).log(Level.SEVERE, null, ex);
        }
        return cadena;
    }
}

