/*
 * Decompiled with CFR 0.152.
 */
package forsedi.criptografia;

import forsedi.criptografia.excepcion.CriptografiaExcepcion;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class Criptografia {
    private static int iterationCount = 19;
    private Cipher ecipher = null;
    private Cipher dcipher = null;
    private static byte[] salt = new byte[]{-8, -89, -63, 44, 106, -72, 19, 16};
    private static final Map<String, Byte> mapHex = new HashMap<String, Byte>();

    private Criptografia(String passPhrase) throws CriptografiaExcepcion {
        try {
            PBEKeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray(), salt, iterationCount);
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
            this.ecipher = Cipher.getInstance(key.getAlgorithm());
            this.dcipher = Cipher.getInstance(key.getAlgorithm());
            PBEParameterSpec paramSpec = new PBEParameterSpec(salt, iterationCount);
            this.ecipher.init(1, (Key)key, paramSpec);
            this.dcipher.init(2, (Key)key, paramSpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CriptografiaExcepcion("No se encontro el metodo", "forsedi.criptografia.Criptografia.NoSuchAlgorithmException." + nsae);
        }
        catch (InvalidKeySpecException ikse) {
            throw new CriptografiaExcepcion("Error en la especificacion de la llave", "forsedi.criptografia.Criptografia.InvalidKeySpecException." + ikse);
        }
        catch (InvalidKeyException ike) {
            throw new CriptografiaExcepcion("Error al utilizar la llave", "forsedi.criptografia.Criptografia.InvalidKeyException." + ike);
        }
        catch (NoSuchPaddingException nspe) {
            throw new CriptografiaExcepcion("Error en la llave", "forsedi.criptografia.Criptografia.NoSuchPaddingException." + nspe);
        }
        catch (InvalidAlgorithmParameterException nsae) {
            throw new CriptografiaExcepcion("Error en los parametros enviados junto con la llave", "forsedi.criptografia.Criptografia.InvalidAlgorithmParameterException." + nsae);
        }
    }

    public static String encriptar(String textPlain, String passPrase) throws CriptografiaExcepcion {
        String result = "";
        try {
            passPrase = passPrase.trim().length() > 0 ? passPrase : "FormasDigitalesForsedi";
            Criptografia crypto = new Criptografia(passPrase);
            byte[] outEncrypted = crypto.encrypt(textPlain.getBytes("UTF-8"));
            result = Criptografia.encodeHexString(outEncrypted);
        }
        catch (CriptografiaExcepcion ce) {
            System.out.println(ce.getLocalizedMessage());
        }
        catch (UnsupportedEncodingException uee) {
            throw new CriptografiaExcepcion("La codificacion \"UTF-8\" no es soportada", "forsedi.criptografia.Criptografia.desencriptar.UnsupportedEncodingException.", uee);
        }
        return result;
    }

    public static String encriptar(String textPlain) throws CriptografiaExcepcion {
        String result = "";
        try {
            Criptografia crypto = new Criptografia("FormasDigitalesForsedi");
            byte[] outEncrypted = crypto.encrypt(textPlain.getBytes("UTF-8"));
            result = Criptografia.encodeHexString(outEncrypted);
        }
        catch (CriptografiaExcepcion ce) {
            System.out.println(ce.getLocalizedMessage());
        }
        catch (UnsupportedEncodingException uee) {
            throw new CriptografiaExcepcion("La codificacion \"UTF-8\" no es soportada", "forsedi.criptografia.Criptografia.desencriptar.UnsupportedEncodingException.", uee);
        }
        return result;
    }

    public static String desencriptar(String textEncrypt, String passPrase) throws CriptografiaExcepcion {
        String result = "";
        try {
            passPrase = passPrase.trim().length() > 0 ? passPrase : "FormasDigitalesForsedi";
            Criptografia crypto = new Criptografia(passPrase);
            byte[] dataEncrypted = Criptografia.decodeHex(textEncrypt.toCharArray());
            byte[] dataPlain = crypto.decrypt(dataEncrypted);
            result = new String(dataPlain, "UTF-8");
        }
        catch (CriptografiaExcepcion ce) {
            System.out.println(ce.getLocalizedMessage());
        }
        catch (UnsupportedEncodingException uee) {
            throw new CriptografiaExcepcion("La codificacion \"UTF-8\" no es soportada", "forsedi.criptografia.Criptografia.desencriptar.UnsupportedEncodingException.", uee);
        }
        return result;
    }

    public static String desencriptar(String textEncrypt) throws CriptografiaExcepcion {
        String result = "";
        try {
            Criptografia crypto = new Criptografia("FormasDigitalesForsedi");
            byte[] dataEncrypted = Criptografia.decodeHex(textEncrypt.toCharArray());
            byte[] dataPlain = crypto.decrypt(dataEncrypted);
            result = new String(dataPlain, "UTF-8");
        }
        catch (CriptografiaExcepcion ce) {
            System.err.println(ce.getLocalizedMessage());
            throw new CriptografiaExcepcion("La codificacion \"UTF-8\" no es soportada", "forsedi.criptografia.Criptografia.desencriptar.CriptografiaExcepcion.", ce);
        }
        catch (UnsupportedEncodingException uee) {
            throw new CriptografiaExcepcion("La codificacion \"UTF-8\" no es soportada", "forsedi.criptografia.Criptografia.desencriptar.UnsupportedEncodingException.", uee);
        }
        return result;
    }

    private static String toFormatHex(byte b) {
        String tmp = String.format("00%x ", b < 0 ? b + 256 : b);
        return tmp.substring(tmp.length() - 3, tmp.length() - 1);
    }

    private static String encodeHexString(byte[] data) {
        String result = "";
        for (byte b : data) {
            result = result + Criptografia.toFormatHex(b);
        }
        return result.toUpperCase();
    }

    private static byte[] decodeHex(char[] data) throws CriptografiaExcepcion {
        if (data.length % 2 != 0) {
            throw new CriptografiaExcepcion("Los datos hexadecimales recibidos estan mal formados", "forsedi.criptografia.Criptografia.decodeHex.");
        }
        byte[] result = new byte[data.length / 2];
        boolean firstByte = true;
        byte hByte = 0;
        byte lByte = 0;
        int pos = 0;
        for (char c : data) {
            if (firstByte) {
                hByte = mapHex.get("" + c);
                hByte = (byte)(hByte << 4);
            } else {
                lByte = mapHex.get("" + c);
                result[pos++] = (byte)(hByte | lByte);
            }
            firstByte = !firstByte;
        }
        return result;
    }

    private byte[] encrypt(byte[] input) throws CriptografiaExcepcion {
        byte[] enc = null;
        try {
            enc = this.ecipher.doFinal(input);
        }
        catch (IllegalBlockSizeException ibse) {
            enc = new byte[]{};
            throw new CriptografiaExcepcion("Tama\u00f1o de bloque de datos incorrecto", "forsedi.criptografia.Criptografia.encrypt.IllegalBlockSizeException", ibse);
        }
        catch (BadPaddingException bpe) {
            enc = new byte[]{};
            throw new CriptografiaExcepcion("Formato bloque de datos incorrecto", "forsedi.criptografia.Criptografia.encrypt.BadPaddingException", bpe);
        }
        return enc;
    }

    private byte[] decrypt(byte[] input) throws CriptografiaExcepcion {
        byte[] dec = null;
        try {
            dec = this.dcipher.doFinal(input);
        }
        catch (IllegalBlockSizeException ibse) {
            dec = new byte[]{};
            throw new CriptografiaExcepcion("Tama\u00f1o de bloque de datos incorrecto", "forsedi.criptografia.Criptografia.null.IllegalBlockSizeException", ibse);
        }
        catch (BadPaddingException bpe) {
            dec = new byte[]{};
            throw new CriptografiaExcepcion("Formato bloque de datos incorrecto", "forsedi.criptografia.Criptografia.null.BadPaddingException", bpe);
        }
        return dec;
    }

    public static void main(String[] args) {
        try {
            System.out.println(Criptografia.desencriptar("B5BE74C40938770A45EE359A6C6004A8"));
            System.out.println(Criptografia.desencriptar("F0B1AEDB6FB165CA1ACE97D4D2321139"));
            System.out.println(Criptografia.desencriptar("A5C06F6D2585467E"));
            System.out.println(Criptografia.desencriptar("C8F23CD875774673"));
            System.out.println(Criptografia.desencriptar("E4B5D3FE1EA4D9A6FF978B61BD354151"));
            System.out.println(Criptografia.desencriptar("21D647C7E52CE40DF41CFC10317792FE"));
            System.out.println(Criptografia.desencriptar("F5ED87F6FAE2C9ADBD2B39C233D473EF"));
            System.out.println(Criptografia.encriptar("forsedi2013"));
            System.out.println(Criptografia.desencriptar("BD2CF643CD6F7E8D"));
            System.out.println(Criptografia.desencriptar("A5C06F6D2585467E"));
            System.out.println(Criptografia.encriptar("sellorojo"));
            System.out.println(Criptografia.encriptar("AH0122"));
            System.out.println(Criptografia.encriptar("grupobto"));
            System.out.println("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        mapHex.put("0", (byte)0);
        mapHex.put("1", (byte)1);
        mapHex.put("2", (byte)2);
        mapHex.put("3", (byte)3);
        mapHex.put("4", (byte)4);
        mapHex.put("5", (byte)5);
        mapHex.put("6", (byte)6);
        mapHex.put("7", (byte)7);
        mapHex.put("8", (byte)8);
        mapHex.put("9", (byte)9);
        mapHex.put("A", (byte)10);
        mapHex.put("B", (byte)11);
        mapHex.put("C", (byte)12);
        mapHex.put("D", (byte)13);
        mapHex.put("E", (byte)14);
        mapHex.put("F", (byte)15);
    }
}

