/*
 * Decompiled with CFR 0.152.
 */
package forsedi.criptografia;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Checksum {
    public static void main(String[] args) throws Exception {
        String datafile = "C:\\SVN\\Conectores2017\\ConectorGenerico\\Conector_CFDI33\\ConfigurationFiles_CFD\\XSL\\disenio_cfdi33.xsl";
        System.out.println(Checksum.getChecksum(datafile));
    }

    public static String getChecksum(String file) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            ChecksumFileInputStream fis = new ChecksumFileInputStream(new File(file));
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            while ((nread = fis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byte[] mdbytes = md.digest();
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(Checksum.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Checksum.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Checksum.class.getName()).log(Level.SEVERE, null, ex);
        }
        return "";
    }

    public static class ChecksumFileInputStream
    extends InputStream {
        private File mFile;
        private List<File> mFiles;
        private InputStream mInputStream;

        public ChecksumFileInputStream(File file) throws FileNotFoundException {
            this.mFile = file;
            if (file.isDirectory()) {
                this.mFiles = new ArrayList<File>(Arrays.asList(file.listFiles()));
                Collections.sort(this.mFiles);
                this.mInputStream = this.nextInputStream();
            } else {
                this.mFiles = new ArrayList<File>();
                this.mInputStream = new FileInputStream(file);
            }
        }

        @Override
        public int read() throws IOException {
            int result;
            int n = result = this.mInputStream == null ? -1 : this.mInputStream.read();
            if (result < 0 && (this.mInputStream = this.nextInputStream()) != null) {
                return this.read();
            }
            return result;
        }

        protected String getRelativePath(File file) {
            return file.getAbsolutePath().substring(this.mFile.getAbsolutePath().length());
        }

        protected InputStream nextInputStream() throws FileNotFoundException {
            if (!this.mFiles.isEmpty()) {
                File nextFile = this.mFiles.remove(0);
                return new SequenceInputStream(new ByteArrayInputStream(this.getRelativePath(nextFile).getBytes()), new ChecksumFileInputStream(nextFile));
            }
            return null;
        }
    }
}

