/*
 * Decompiled with CFR 0.152.
 */
package com.forsedi.update.ws;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.formas.aws.UploadFile;
import com.formas.bean.Bucket;
import com.forsedi.update.Update;
import com.forsedi.update.register.LicenseUtils;
import com.forsedi.update.register.Update_TempRegistration;
import com.forsedi.update.register.UtileriasLicencia;
import com.forsedi.update.util.Util;
import com.forsedi.update.util.UtilsFiles;
import com.forsedi.update.ws.model.Response_Update;
import com.forsedi.update.ws.model.Response_Update_ListConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;

public class UpdateService {
    public static Response_Update checkUpdates(String url, String id_installation) throws Exception {
        if (Util.isEmpty(id_installation)) {
            throw new Exception("No se pudo obtener la licencia del Conector Forsedi");
        }
        String jsonResponse = UpdateService.getRest(url + "/AppConectores/updateservice/" + id_installation);
        if (!Util.isEmpty(jsonResponse)) {
            ObjectMapper mapper = new ObjectMapper();
            Response_Update response = mapper.readValue(jsonResponse, Response_Update.class);
            return response;
        }
        return null;
    }

    public static boolean sendUpdateSuccess(Update update) {
        boolean bool = UpdateService.sendUpdateSuccess(update.getUrlUpdates(), update.getErrores(), update.getPendingUpdates(), update.getId_installation(), update.getResponseUpdates().getActualDate());
        return bool;
    }

    public static boolean sendUpdateSuccess(String url, List<String> errores, List<Response_Update_ListConfiguration> pendingUpdates, String id_installation, String date) {
        try {
            url = url + "/AppConectores/updateservice/";
            System.out.println(url);
            if (errores.isEmpty()) {
                for (Response_Update_ListConfiguration update : pendingUpdates) {
                    String uri = url + "?id_installation=" + id_installation + "&updateDate=" + date + "&cfg_update_id=" + update.getId();
                    String jsonResponse = UpdateService.postRest(uri);
                    System.out.println(uri);
                }
            } else {
                String error = "";
                for (String err : errores) {
                    error = error + err + "\n";
                }
                String uri = "error?id_installation=" + id_installation + "&errorDate=" + date + "&error_description=" + URLEncoder.encode(error, "UTF-8");
                String jsonResponse = UpdateService.postRest(uri);
                System.out.println(uri);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(UpdateService.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String postRest(String urlString) throws MalformedURLException, URISyntaxException {
        String jsonResponse = "";
        Response response = null;
        URL url = new URL(urlString);
        String nullFragment = null;
        URI uri = new URI(url.getProtocol(), nullFragment, url.getHost(), url.getPort(), url.getPath(), url.getQuery(), nullFragment);
        try {
            Client client = ClientBuilder.newClient();
            WebTarget target = client.target(uri);
            Invocation.Builder invocationBuilder = target.request("application/json");
            MultivaluedHashMap<String, String> requestParams = new MultivaluedHashMap<String, String>();
            response = invocationBuilder.post(Entity.form(requestParams));
            jsonResponse = response.readEntity(String.class);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        return jsonResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRest(String urlString) throws MalformedURLException, URISyntaxException {
        String jsonResponse = "";
        Response response = null;
        URL url = new URL(urlString);
        String nullFragment = null;
        URI uri = new URI(url.getProtocol(), nullFragment, url.getHost(), url.getPort(), url.getPath(), url.getQuery(), nullFragment);
        try {
            Client client = ClientBuilder.newClient();
            WebTarget target = client.target(uri);
            Invocation.Builder invocationBuilder = target.request("application/json");
            MultivaluedHashMap requestParams = new MultivaluedHashMap();
            response = invocationBuilder.get();
            jsonResponse = response.readEntity(String.class);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        return jsonResponse;
    }

    public static void addURL() throws FileNotFoundException, IOException, Exception {
        String url = "";
        String executionPath = System.getProperty("user.dir");
        File folderConfigs = new File(executionPath + "/ConfigurationFiles_CFD");
        String idEquipo = UtileriasLicencia.getMachineID();
        Properties configProps = new Properties();
        File configuration = new File(executionPath + "/ConfigurationFiles_CFD/configuracion.properties");
        FileInputStream fisConfg = new FileInputStream(configuration);
        configProps.load(fisConfg);
        url = "https://forsedi.facturacfdi.mx/";
        System.out.println(url);
        if (url == null || url.isEmpty()) {
            List<String> lines = UtilsFiles.getLines(executionPath + "/ConfigurationFiles_CFD/configuracion.properties");
            lines.add("URL_UPDATES=https://forsedi.facturacfdi.mx/");
            lines.add("UPDATE_BINARIES=1");
            lines.add("UPDATE_CONFIG=1");
            lines.add("UPDATE_DESIGNS=1");
            StringBuilder strLines = new StringBuilder();
            lines.forEach(line -> strLines.append((String)line).append("\n"));
            UtilsFiles.writeFile(executionPath + "/ConfigurationFiles_CFD/configuracion.properties", strLines.toString());
            url = "https://dev.facturacfdi.mx:8083";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sendRegistration() throws Exception {
        String executionPath = System.getProperty("user.dir");
        File folderConfigs = new File(executionPath + "/ConfigurationFiles_CFD");
        if (folderConfigs.exists() && folderConfigs.isDirectory()) {
            String url = "";
            String idEquipo = UtileriasLicencia.getMachineID();
            Properties configProps = new Properties();
            File configuration = new File(executionPath + "/ConfigurationFiles_CFD/configuracion.properties");
            FileInputStream fisConfg = new FileInputStream(configuration);
            configProps.load(fisConfg);
            url = "https://forsedi.facturacfdi.mx/";
            System.out.println(url);
            if (url == null || url.isEmpty()) {
                List<String> lines = UtilsFiles.getLines(executionPath + "/ConfigurationFiles_CFD/configuracion.properties");
                lines.add("\nURL_UPDATES=https://dev.facturacfdi.mx:8083");
                lines.add("#URL_UPDATES=https://forsedi.facturacfdi.mx/");
                lines.add("UPDATE_BINARIES=1");
                lines.add("UPDATE_CONFIG=1");
                lines.add("UPDATE_DESIGNS=1");
                StringBuilder strLines = new StringBuilder();
                lines.forEach(line -> strLines.append((String)line).append("\n"));
                UtilsFiles.writeFile(executionPath + "/ConfigurationFiles_CFD/configuracion.properties", strLines.toString());
                url = "https://dev.facturacfdi.mx:8083";
            }
            try {
                File checkFile = new File(executionPath + "/" + LicenseUtils.generaLicencia(idEquipo, 2) + ".zip");
                if (checkFile.exists()) {
                    checkFile.delete();
                }
                ZipFile zipFile = new ZipFile(executionPath + "/" + LicenseUtils.generaLicencia(idEquipo, 2) + ".zip");
                String folderToAdd = executionPath + "/ConfigurationFiles_CFD";
                ZipParameters parameters = new ZipParameters();
                parameters.setCompressionMethod(8);
                parameters.setCompressionLevel(5);
                zipFile.addFolder(folderToAdd, parameters);
                Bucket bucket = new Bucket("updateconectores", "AKIAJXOJDSAXRLYDS2NA", "JpU3gX+nh5wfnp3MTHTu5HFtPkKM3VcfSfmPQAi1");
                UploadFile uploadtos3 = new UploadFile(bucket);
                File zip2Upload = new File(executionPath + "/" + LicenseUtils.generaLicencia(idEquipo, 2) + ".zip");
                uploadtos3.uploadPublicZipFile(zip2Upload, "BackupsEmisores/" + zip2Upload.getName(), true);
                zip2Upload.delete();
            }
            catch (ZipException e) {
                e.printStackTrace();
            }
            try {
                url = url + "/AppConectores/updateservice/registerClient/";
                File folder = new File("ConfigurationFiles_CFD/empresas/");
                File[] listOfEmisores = folder.listFiles();
                Properties propsEmisor = new Properties();
                LinkedList<Update_TempRegistration> emisores = new LinkedList<Update_TempRegistration>();
                System.out.println("Emisores registrados:");
                for (File f : listOfEmisores) {
                    Update_TempRegistration emisor = new Update_TempRegistration();
                    try (FileInputStream fis = null;){
                        fis = new FileInputStream(f);
                        propsEmisor.load(fis);
                        emisor.setRfc(propsEmisor.getProperty("RFC"));
                        emisor.setRazon_social(propsEmisor.getProperty("NOMBRE"));
                        emisor.setId_equipo(idEquipo);
                        emisor.setLicencia(LicenseUtils.generaLicencia(emisor.getId_equipo(), 2));
                        emisor.setInstallation_path(executionPath);
                        if (!propsEmisor.getProperty("RFC").contains("disenio_cfdi33")) {
                            emisor.setTipoConector(1);
                        } else {
                            emisor.setTipoConector(2);
                        }
                        emisores.add(emisor);
                        String uri = url + "?rfc=" + emisor.getRfc() + "&razon_social=" + emisor.getRazon_social() + "&id_equipo=" + emisor.getId_equipo() + "&licencia=" + emisor.getLicencia() + "&installation_path=" + emisor.getInstallation_path() + "&tipoConector=" + emisor.getTipoConector();
                        String jsonResponse = UpdateService.postRest(uri);
                        System.out.println(emisor.getRfc());
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger(UpdateService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }
}

