/*
 * Decompiled with CFR 0.152.
 */
package com.forsedi.update.util;

import com.forsedi.update.Main;
import com.forsedi.update.model.Control;
import com.forsedi.update.model.Control_ObjectFactory;
import com.forsedi.update.util.Util;
import com.forsedi.update.util.UtilsFiles;
import com.forsedi.update.ws.model.Response_Update_ListConfiguration;
import forsedi.criptografia.Checksum;
import forsedi.criptografia.Criptografia;
import forsedi.criptografia.excepcion.CriptografiaExcepcion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class UtilsUpdate {
    public static Control loadControlVersion(String licencia) throws Exception {
        File controlVersionFile = new File("ConfigurationFiles_CFD/Logs/config/controlVersion.xml");
        Control controlVersion = null;
        try {
            if (!controlVersionFile.exists()) {
                File folder = controlVersionFile.getParentFile();
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                controlVersion = UtilsUpdate.generateFirstControlVersion(licencia);
                UtilsUpdate.saveControlVersion(controlVersion);
            } else {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Control.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                controlVersion = (Control)jaxbUnmarshaller.unmarshal(controlVersionFile);
            }
        }
        catch (JAXBException ex) {
            Logger.getLogger(UtilsUpdate.class.getName()).log(Level.SEVERE, null, ex);
            throw new Exception("No se pudo cargar el Log de control de versiones");
        }
        return controlVersion;
    }

    private static Control generateFirstControlVersion(String licencia) {
        Control_ObjectFactory of = new Control_ObjectFactory();
        Control control = of.createControl();
        Control.Files files = of.createControlFiles();
        Control.Logs logs = of.createControlLogs();
        UtilsUpdate.loadControlFiles(files);
        control.setLicencia(licencia);
        control.setLastUpdateBinaries("");
        control.setLastUpdateConfig("");
        control.setLastUpdateDesigns("");
        control.setFiles(files);
        control.setLogs(logs);
        return control;
    }

    private static void loadControlFiles(Control controlVersion, List<Response_Update_ListConfiguration> pendingUpdates) {
        Control_ObjectFactory of = new Control_ObjectFactory();
        Control.Files files = of.createControlFiles();
        UtilsUpdate.loadControlFiles(files);
        for (Response_Update_ListConfiguration update : pendingUpdates) {
            for (Control.Files.FileUpdate fileUpdate : files.getFileUpdate()) {
                if (!fileUpdate.getName().equals(update.getFilename())) continue;
                fileUpdate.setReleaseDate(update.getReleaseDate());
            }
        }
        controlVersion.setFiles(files);
    }

    private static void loadControlFiles(Control.Files files) {
        DirectoryStream<Path> stream;
        Path dir;
        Control_ObjectFactory of = new Control_ObjectFactory();
        try {
            dir = FileSystems.getDefault().getPath("ConfigurationFiles_CFD/", new String[0]);
            stream = Files.newDirectoryStream(dir, "*.{properties,xml}");
            for (Path path : stream) {
                UtilsUpdate.loadCF(path, of, files);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(UtilsUpdate.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            dir = FileSystems.getDefault().getPath("ConfigurationFiles_CFD/empresas/", new String[0]);
            stream = Files.newDirectoryStream(dir, "*.{properties}");
            for (Path path : stream) {
                UtilsUpdate.loadCF(path, of, files);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(UtilsUpdate.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            dir = FileSystems.getDefault().getPath("ConfigurationFiles_CFD/empresas/", new String[0]);
            stream = Files.newDirectoryStream(dir, "sucursales*.{xml}");
            for (Path path : stream) {
                UtilsUpdate.loadCF(path, of, files);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(UtilsUpdate.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            dir = FileSystems.getDefault().getPath("ConfigurationFiles_CFD/XSL/", new String[0]);
            stream = Files.newDirectoryStream(dir, "disenio*.{xsl, xslt}");
            for (Path path : stream) {
                UtilsUpdate.loadCF(path, of, files);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(UtilsUpdate.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static void loadCF(Path pathFile, Control_ObjectFactory of, Control.Files files) {
        File file = new File(pathFile.toString());
        Control.Files.FileUpdate fileUpdate = of.createControlFilesFileUpdate();
        fileUpdate.setName(file.getName());
        fileUpdate.setPath("ConfigurationFiles_CFD/XSL/");
        fileUpdate.setReleaseDate("");
        fileUpdate.setChecksum(Checksum.getChecksum(file.getAbsolutePath()));
        files.getFileUpdate().add(fileUpdate);
    }

    public static boolean saveControlVersion(Control controlVersion) throws JAXBException {
        File controlVersionFile = new File("ConfigurationFiles_CFD/Logs/config/controlVersion.xml");
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Control.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        jaxbMarshaller.marshal((Object)controlVersion, controlVersionFile);
        return true;
    }

    public static void updateControlVersion(Control controlVersion, List<String> errores, List<Response_Update_ListConfiguration> pendingUpdates, File backupFolder) throws JAXBException {
        Control.Logs.Log log = new Control.Logs.Log();
        if (backupFolder != null && backupFolder.exists()) {
            log.setBackupPath(backupFolder.getAbsolutePath());
        }
        log.setDate(Util.dateToStr(new Date()));
        String info = "";
        for (Response_Update_ListConfiguration response_Update_ListConfiguration : pendingUpdates) {
            info = info + "[" + response_Update_ListConfiguration.getFilename() + ":\t" + response_Update_ListConfiguration.getReleaseDate() + "]";
        }
        log.setInfo(info);
        if (errores.size() > 0) {
            StringBuilder str = new StringBuilder();
            for (String err : errores) {
                str.append(err);
            }
            log.setErrors(str.toString());
        } else {
            for (Response_Update_ListConfiguration response_Update_ListConfiguration : pendingUpdates) {
                if (response_Update_ListConfiguration.getFilename().equals("Binaries.zip")) {
                    controlVersion.setLastUpdateBinaries(response_Update_ListConfiguration.getReleaseDate());
                    continue;
                }
                if (response_Update_ListConfiguration.getFilename().equals("Configuration.zip")) {
                    controlVersion.setLastUpdateConfig(response_Update_ListConfiguration.getReleaseDate());
                    continue;
                }
                if (!response_Update_ListConfiguration.getFilename().equals("Designs.zip")) continue;
                controlVersion.setLastUpdateDesigns(response_Update_ListConfiguration.getReleaseDate());
            }
        }
        if (!Util.isEmpty(log)) {
            controlVersion.getLogs().getLog().add(log);
        }
        if (errores.isEmpty()) {
            UtilsUpdate.loadControlFiles(controlVersion, pendingUpdates);
        }
        UtilsUpdate.saveControlVersion(controlVersion);
    }

    public static boolean updateProperties(String newFilePath, String oldFilePath) {
        try {
            Properties newProperties = UtilsFiles.loadProperties(newFilePath);
            Properties oldProperties = UtilsFiles.loadProperties(oldFilePath);
            List<String> lines = UtilsFiles.getLines(newFilePath);
            oldProperties.keySet().stream().map(o -> (String)o).forEachOrdered(key -> {
                boolean encontrado = false;
                if (newProperties.get(key) != null) {
                    for (int i = 0; i < lines.size(); ++i) {
                        String line = ((String)lines.get(i)).trim();
                        if (!line.startsWith(key + "=") && !line.startsWith(key + " ")) continue;
                        encontrado = true;
                        lines.set(i, key + "=" + oldProperties.get(key));
                    }
                }
                if (!encontrado) {
                    lines.add("\n# REMOVED -> " + key + "=" + oldProperties.getProperty((String)key));
                }
            });
            File oldFile = new File(oldFilePath);
            if (oldFile.exists()) {
                oldFile.delete();
            }
            StringBuilder strLines = new StringBuilder();
            lines.forEach(line -> strLines.append((String)line).append("\n"));
            UtilsFiles.writeFile(oldFilePath, strLines.toString());
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(UtilsFiles.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static boolean updateProperties(String newFilePath, String oldFilePath, Properties properties) {
        try {
            Properties newProperties = UtilsFiles.loadProperties(newFilePath);
            Properties oldProperties = UtilsFiles.loadProperties(oldFilePath);
            List<String> lines = UtilsFiles.getLines(newFilePath);
            oldProperties.keySet().stream().map(o -> (String)o).forEachOrdered(key -> {
                boolean encontrado = false;
                if (newProperties.get(key) != null) {
                    for (int i = 0; i < lines.size(); ++i) {
                        String line = ((String)lines.get(i)).trim();
                        if (!line.startsWith(key + "=") && !line.startsWith(key + " ")) continue;
                        encontrado = true;
                        lines.set(i, key + "=" + oldProperties.get(key));
                    }
                }
                if (!encontrado) {
                    lines.add("\n# REMOVED -> " + key + "=" + oldProperties.getProperty((String)key));
                }
            });
            File oldFile = new File(oldFilePath);
            if (oldFile.exists()) {
                oldFile.delete();
            }
            StringBuilder strLines = new StringBuilder();
            lines.forEach(line -> strLines.append((String)line).append("\n"));
            UtilsFiles.writeFile(oldFilePath, strLines.toString());
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(UtilsFiles.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static int propToInt(String str) {
        try {
            if (!Util.isEmpty(str)) {
                return Integer.parseInt(str.trim());
            }
        }
        catch (NumberFormatException ex) {
            Logger.getLogger(UtilsFiles.class.getName()).log(Level.SEVERE, null, ex);
        }
        return 0;
    }

    public static boolean isRunningConector() {
        try {
            FileChannel channel;
            FileLock lock;
            File f = new File("RingOnRequest.lock");
            if (f.exists()) {
                f.delete();
            }
            if ((lock = (channel = new RandomAccessFile(f, "rw").getChannel()).tryLock()) == null) {
                channel.close();
                throw new RuntimeException("No se puede realizar la actualizaci\u00f3n si una instancia del conector se esta ejecutando.");
            }
            return false;
        }
        catch (Exception ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            return true;
        }
    }

    public static boolean isInstalled() {
        boolean existe = false;
        ArrayList<File> archivos = new ArrayList<File>();
        archivos.add(new File("ForsediV33.jar"));
        archivos.add(new File("ConfigurationFiles_CFD/"));
        for (File f : archivos) {
            if (!f.exists()) continue;
            existe = true;
            break;
        }
        return existe;
    }

    public static String getMD5(String content) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(content.getBytes());
            StringBuilder sb = new StringBuilder(2 * bytes.length);
            for (int i = 0; i < bytes.length; ++i) {
                int low = bytes[i] & 0xF;
                int high = (bytes[i] & 0xF0) >> 4;
                sb.append(Integer.toHexString(high));
                sb.append(Integer.toHexString(low));
            }
            String fakemd5 = sb.toString().toUpperCase();
            fakemd5 = Criptografia.encriptar(fakemd5, "FormasDigitalesForsedi33");
            System.out.println(fakemd5);
            return sb.toString().toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
        catch (CriptografiaExcepcion ex) {
            Logger.getLogger(UtilsUpdate.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }

    public static String getMachineID() throws Exception {
        StringBuilder machineId = new StringBuilder();
        try {
            machineId.append(UtilsUpdate.getSerialNumber("C"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            machineId.append(UtilsUpdate.getMotherboardSN());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (machineId.length() <= 0) {
            throw new Exception("No se pudo generar el identificador del equipo, verifique con soporte.");
        }
        try {
            String dir = System.getProperty("user.dir");
            machineId.append(dir);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String token = UtilsUpdate.getMD5(machineId.toString()).toUpperCase();
        if (token == null || token.trim().isEmpty()) {
            throw new Exception("No se pudo generar el identificador del equipo, verifique con soporte.");
        }
        return token;
    }

    public static String getSerialNumber(String drive) {
        String result = "";
        try {
            String line;
            File file = File.createTempFile("realhowto", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "Set objFSO = CreateObject(\"Scripting.FileSystemObject\")\nSet colDrives = objFSO.Drives\nSet objDrive = colDrives.item(\"" + drive + "\")\nWscript.Echo objDrive.SerialNumber";
            fw.write(vbs);
            fw.close();
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = result + line;
            }
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.trim();
    }

    public static String getMotherboardSN() {
        String result = "";
        try {
            String line;
            File file = File.createTempFile("realhowto", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n   (\"Select * from Win32_BaseBoard\") \nFor Each objItem in colItems \n    Wscript.Echo objItem.SerialNumber \n    exit for  ' do the first cpu only! \nNext \n";
            fw.write(vbs);
            fw.close();
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = result + line;
            }
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void crearBat() {
        InputStream in = UtilsUpdate.class.getResourceAsStream("/com/forsedi/update/util/start_conector.bat");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File("start_conector.bat"));
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = in.read(bytes)) != -1) {
                out.write(bytes, 0, read);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(UtilsUpdate.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(UtilsUpdate.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

