/*
 * Decompiled with CFR 0.152.
 */
package com.forsedi.update.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UtilsFiles {
    public static Properties loadProperties(String path) throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        try (FileInputStream fis = null;){
            fis = new FileInputStream(path);
            properties.load(fis);
        }
        return properties;
    }

    public static List<String> getLines(String path) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        String s;
        ArrayList<String> lines = new ArrayList<String>();
        FileInputStream ins = new FileInputStream(path);
        InputStreamReader r = new InputStreamReader((InputStream)ins, "UTF-8");
        BufferedReader br = new BufferedReader(r);
        while ((s = br.readLine()) != null) {
            lines.add(s);
        }
        return lines;
    }

    public static void writeFile(String filePath, String str) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));){
            writer.write(str);
        }
    }

    public static void copyFolder(File src, File dest, List<String> ignore) throws IOException {
        if (!ignore.contains(src.getName())) {
            if (src.isDirectory()) {
                String[] files;
                if (!dest.exists()) {
                    dest.mkdir();
                }
                for (String file : files = src.list()) {
                    File srcFile = new File(src, file);
                    File destFile = new File(dest, file);
                    UtilsFiles.copyFolder(srcFile, destFile, ignore);
                }
            } else {
                int length;
                FileInputStream in = new FileInputStream(src);
                FileOutputStream out = new FileOutputStream(dest);
                byte[] buffer = new byte[1024];
                while ((length = ((InputStream)in).read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, length);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
        }
    }

    public static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    UtilsFiles.deleteFolder(f);
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }

    public static boolean backupFile(File file, String path) {
        String backupName = file.getName();
        return UtilsFiles.backupFile(file, path, backupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean backupFile(File file, String path, String backupName) {
        ArrayList<String> ignore = new ArrayList<String>();
        System.out.println("Backup: " + file.getAbsolutePath() + " to " + path + "/" + backupName);
        if (file.isDirectory()) {
            try {
                UtilsFiles.copyFolder(file, new File(path + "/" + backupName), ignore);
                return true;
            }
            catch (IOException ex) {
                Logger.getLogger(UtilsFiles.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            int length;
            File backupFile = new File(path + "/" + backupName);
            in = new FileInputStream(file);
            out = new FileOutputStream(backupFile);
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) > 0) {
                out.write(buffer, 0, length);
            }
            in.close();
            out.close();
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(UtilsFiles.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(UtilsFiles.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(UtilsFiles.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public static boolean replaceFile(File oldFile, File newFile) throws IOException {
        System.out.println("Replace: " + newFile.getAbsolutePath() + " to " + oldFile.getAbsolutePath());
        if (oldFile.exists()) {
            if (oldFile.isDirectory()) {
                UtilsFiles.deleteFolder(oldFile);
            } else {
                oldFile.delete();
            }
        }
        if (newFile.isDirectory()) {
            UtilsFiles.copyFolder(newFile, oldFile, new ArrayList<String>());
        } else {
            newFile.renameTo(oldFile);
        }
        return true;
    }

    public static class FolderInputStream
    extends InputStream {
        private File mFile;
        private List<File> mFiles;
        private InputStream mInputStream;

        public FolderInputStream(File file) throws FileNotFoundException {
            this.mFile = file;
            if (file.isDirectory()) {
                this.mFiles = new ArrayList<File>(Arrays.asList(file.listFiles()));
                Collections.sort(this.mFiles);
                this.mInputStream = this.nextInputStream();
            } else {
                this.mFiles = new ArrayList<File>();
                this.mInputStream = new FileInputStream(file);
            }
        }

        @Override
        public int read() throws IOException {
            int result;
            int n = result = this.mInputStream == null ? -1 : this.mInputStream.read();
            if (result < 0 && (this.mInputStream = this.nextInputStream()) != null) {
                return this.read();
            }
            return result;
        }

        protected String getRelativePath(File file) {
            return file.getAbsolutePath().substring(this.mFile.getAbsolutePath().length());
        }

        protected InputStream nextInputStream() throws FileNotFoundException {
            if (!this.mFiles.isEmpty()) {
                File nextFile = this.mFiles.remove(0);
                return new SequenceInputStream(new ByteArrayInputStream(this.getRelativePath(nextFile).getBytes()), new FolderInputStream(nextFile));
            }
            return null;
        }
    }
}

