/*
 * Decompiled with CFR 0.152.
 */
package com.forsedi.update.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Util {
    public static boolean isEmpty(Object s) {
        return s == null || s.toString().trim().equals("");
    }

    public static int toInt(String value) {
        if (Util.isEmpty(value)) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public static long toLong(String value) {
        if (Util.isEmpty(value)) {
            return 0L;
        }
        return Long.parseLong(value);
    }

    public static double toDouble(String value) {
        if (Util.isEmpty(value)) {
            return 0.0;
        }
        return Double.parseDouble(value);
    }

    public static String timeToStr(Long time, String format) {
        if (Util.isEmpty(time)) {
            time = 100000000000L;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = new Date(time);
        String str = sdf.format(date);
        return str;
    }

    public static Date strToDate(String str) throws ParseException {
        return Util.strToDate(str, "yyyy-MM-dd hh:mm:ss");
    }

    public static Date strToDate(String str, String format) throws ParseException {
        if (Util.isEmpty(str)) {
            Date date = new Date(100000000000L);
            return date;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = sdf.parse(str);
        return date;
    }

    public static String dateToStr(Date date) {
        return Util.dateToStr(date, "yyyy-MM-dd hh:mm:ss");
    }

    public static String dateToStr(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String str = sdf.format(date);
        return str;
    }

    public static void printTimeLapse(Date begin, String message) {
        Date end = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss:SSS");
        System.out.println(message + "\n" + sdf.format(begin) + " -> " + sdf.format(end) + " ~ " + (end.getTime() - begin.getTime()));
    }
}

