/*
 * Decompiled with CFR 0.152.
 */
package com.forsedi.update.register;

import com.forsedi.update.register.Utilerias;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UtileriasLicencia {
    public static final String LICENCIA_PATH = "ConfigurationFiles_CFD";
    public static final String LICENCIA_NAME = "Licencia.txt";
    public static final String LICENCIA_FILE = "ConfigurationFiles_CFD/Licencia.txt";
    public static final String FORSEDI_TOKEN = "_LICENCIA_CONECTOR_CFDI_NO_COPIAR";

    public boolean verificar() {
        String OS = System.getProperty("os.name");
        if (!OS.toLowerCase().contains("windows")) {
            return true;
        }
        File fileLicencia = new File(LICENCIA_FILE);
        if (fileLicencia.exists()) {
            try {
                String licencia = Utilerias.readFile(LICENCIA_FILE).trim();
                return UtileriasLicencia.isLicenseValid(licencia);
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(UtileriasLicencia.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(UtileriasLicencia.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(UtileriasLicencia.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public boolean verificar(Frame parent) {
        Licencia licencia = new Licencia();
        return licencia.isValida();
    }

    public static boolean isLicenseValid(String license) throws Exception {
        boolean isValid = false;
        String licenciaLocal = UtileriasLicencia.getMachineID() + FORSEDI_TOKEN;
        licenciaLocal = Utilerias.getMD5(licenciaLocal).toUpperCase();
        license = license.replaceAll("-", "");
        isValid = licenciaLocal.equals(license);
        return isValid;
    }

    public static String getMachineID() throws Exception {
        StringBuilder machineId = new StringBuilder();
        try {
            machineId.append(UtileriasLicencia.getSerialNumber("C"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            machineId.append(UtileriasLicencia.getMotherboardSN());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (machineId.length() <= 0) {
            throw new Exception("No se pudo generar el identificador del equipo, verifique con soporte.");
        }
        try {
            String dir = System.getProperty("user.dir");
            machineId.append(dir);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String token = Utilerias.getMD5(machineId.toString()).toUpperCase();
        if (token == null || token.trim().isEmpty()) {
            throw new Exception("No se pudo generar el identificador del equipo, verifique con soporte.");
        }
        return token;
    }

    public static String getSerialNumber(String drive) {
        String result = "";
        try {
            String line;
            File file = File.createTempFile("realhowto", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "Set objFSO = CreateObject(\"Scripting.FileSystemObject\")\nSet colDrives = objFSO.Drives\nSet objDrive = colDrives.item(\"" + drive + "\")\nWscript.Echo objDrive.SerialNumber";
            fw.write(vbs);
            fw.close();
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = result + line;
            }
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.trim();
    }

    public static void main(String[] args) {
        File[] roots;
        for (File root : roots = File.listRoots()) {
            System.out.println(UtileriasLicencia.getSerialNumber(root.getAbsolutePath()));
        }
    }

    public static String getMotherboardSN() {
        String result = "";
        try {
            String line;
            File file = File.createTempFile("realhowto", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n   (\"Select * from Win32_BaseBoard\") \nFor Each objItem in colItems \n    Wscript.Echo objItem.SerialNumber \n    exit for  ' do the first cpu only! \nNext \n";
            fw.write(vbs);
            fw.close();
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = result + line;
            }
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.trim();
    }

    public class Licencia {
        private boolean valida;
        private String idEquipo;
        private String licencia;

        public boolean isValida() {
            return this.valida;
        }

        public void setValida(boolean isValida) {
            this.valida = isValida;
        }

        public String getIdEquipo() {
            return this.idEquipo;
        }

        public void setIdEquipo(String idEquipo) {
            this.idEquipo = idEquipo;
        }

        public String getLicencia() {
            return this.licencia;
        }

        public void setLicencia(String licencia) {
            this.licencia = licencia;
        }
    }
}

