/*
 * Decompiled with CFR 0.152.
 */
package com.forsedi.update.register;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class Utilerias {
    public static final String RFC_REGEX = "[A-Z\u00d1&]{3,4}[0-9]{2}[0-1][0-9][0-3][0-9][A-Z0-9]?[A-Z0-9]?[0-9A-Z]?";
    public static final String UUID_REGEX = "[a-f0-9A-F]{8}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{4}-[a-f0-9A-F]{12}";
    public static final String DEFAULT_CHARSET = "WINDOWS-1252";

    public static String readFile(String strFilePath) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        return Utilerias.readFile(new File(strFilePath), "UTF-8");
    }

    public static String readFile(File file) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        return Utilerias.readFile(file, "UTF-8");
    }

    public static String readFile(File file, String charset) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        StringBuilder datos = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
        String line = br.readLine();
        do {
            datos.append(line).append("\n");
        } while ((line = br.readLine()) != null);
        br.close();
        return datos.toString();
    }

    public static boolean isEmpty(Object s) {
        return s == null || s.toString().trim().equals("");
    }

    public static Object resizeArray(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    public static boolean isValidRFC(String rfc) {
        if (rfc == null) {
            rfc = "";
        }
        return rfc.matches(RFC_REGEX);
    }

    public static boolean isValidUUID(String uuid) {
        if (uuid == null) {
            uuid = "";
        }
        return uuid.matches(UUID_REGEX);
    }

    public static boolean toBoolean(String cadena) {
        try {
            return Boolean.parseBoolean(cadena);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isEmpty(String cadena) {
        return cadena == null || cadena.trim().isEmpty();
    }

    public static String[] subString(String cadena, String[] arrSubAux) {
        String aux = "";
        String[] resultado = new String[]{};
        boolean bandera = true;
        int i = 0;
        cadena = cadena.trim();
        while (bandera) {
            if (cadena.indexOf(arrSubAux[0]) > -1) {
                resultado = (String[])Utilerias.resizeArray(resultado, i + 1);
                resultado[i] = cadena.substring(cadena.indexOf(arrSubAux[0]) + 1, cadena.indexOf(arrSubAux[1], cadena.indexOf(arrSubAux[0]) + 1));
                aux = cadena.trim().substring(cadena.indexOf(arrSubAux[1], cadena.indexOf(arrSubAux[0]) + 1) + 1);
                cadena = cadena.trim().substring(0, cadena.indexOf(arrSubAux[0])) + aux;
            } else {
                bandera = false;
            }
            ++i;
        }
        return resultado;
    }

    public static String[] split(String cadena, char delimitador) {
        String[] arr = new String[]{};
        int conPipe = 0;
        int inicio = 0;
        int indexPipe = cadena.indexOf(delimitador);
        boolean ban = false;
        int contador = 0;
        if (cadena.trim().length() > 0) {
            do {
                if (indexPipe == -1) {
                    ban = true;
                    if (cadena.length() != inicio) {
                        arr = (String[])Utilerias.resizeArray(arr, arr.length + 1);
                        arr[conPipe] = cadena.substring(inicio, cadena.length()).trim();
                    } else {
                        arr = (String[])Utilerias.resizeArray(arr, arr.length + 1);
                        arr[conPipe] = "";
                    }
                } else {
                    arr = (String[])Utilerias.resizeArray(arr, arr.length + 1);
                    arr[conPipe] = cadena.substring(inicio, indexPipe).trim();
                    ++conPipe;
                }
                inicio = indexPipe + 1;
                indexPipe = cadena.indexOf(delimitador, inicio);
                ++contador;
            } while (inicio == indexPipe || !ban);
        }
        return arr;
    }

    public static String getInfoSeccion(String[] arrSub, String[] arrCons, int i) {
        String resultado = Utilerias.subString(arrCons, i, arrSub);
        return resultado;
    }

    public static String subString(String[] arrCons, int i, String[] arrSubAux) {
        String aux = "";
        String resultado = "";
        if (arrCons[i].indexOf(arrSubAux[0]) > -1) {
            resultado = arrCons[i].substring(arrCons[i].indexOf(arrSubAux[0]) + 1, arrCons[i].indexOf(arrSubAux[1], arrCons[i].indexOf(arrSubAux[0]) + 1));
            aux = arrCons[i].substring(arrCons[i].indexOf(arrSubAux[1], arrCons[i].indexOf(arrSubAux[0]) + 1) + 1);
            arrCons[i] = (arrCons[i].substring(0, arrCons[i].indexOf(arrSubAux[0])) + aux).trim();
        }
        return resultado;
    }

    public static double getDouble(Object cadena) {
        if (Utilerias.isEmpty(Utilerias.getString(cadena))) {
            return -1.0;
        }
        return Double.valueOf(cadena.toString());
    }

    public static String doubleToString(double numero) {
        DecimalFormat formato = new DecimalFormat("#.#######");
        return formato.format(numero);
    }

    public static String intToString(int numero) {
        DecimalFormat formato = new DecimalFormat("000");
        return formato.format(numero);
    }

    public static String bigDecimalToString(BigDecimal numero) {
        if (numero == null) {
            return "";
        }
        DecimalFormat formato = new DecimalFormat("0.##");
        return formato.format(numero);
    }

    public static XMLGregorianCalendar calendarToXMLGregorianCalendar(Date fecha) {
        try {
            SimpleDateFormat formato = new SimpleDateFormat("yyyy-MM-dd");
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(formato.format(fecha));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static XMLGregorianCalendar stringToXMLGregorianCalendar(String cadena) {
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(cadena);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BigDecimal stringToBigDecimal(String cadena) {
        try {
            return new BigDecimal(cadena);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getInt(Object cadena) {
        if (Utilerias.isEmpty(Utilerias.getString(cadena))) {
            return -1;
        }
        return Integer.valueOf(cadena.toString());
    }

    public static String getString(Object cadena) {
        if (cadena == null) {
            return "";
        }
        return cadena.toString();
    }

    public static String getStringMes(Object mes) {
        if (mes == null) {
            return "";
        }
        if (mes.toString().length() < 2) {
            mes = "0" + mes.toString();
        }
        return mes.toString();
    }

    public static String limpiaCadena(String cadena) {
        if (Utilerias.isEmpty(cadena)) {
            return "";
        }
        cadena = cadena.replaceAll("\n", "");
        cadena = cadena.replaceAll("\r", "");
        cadena = cadena.replaceAll("\t", "");
        return cadena;
    }

    public static String getMD5(String data) {
        String hashtext = "";
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.reset();
            m.update(data.getBytes());
            byte[] digest = m.digest();
            BigInteger bigInt = new BigInteger(1, digest);
            hashtext = bigInt.toString(16);
            while (hashtext.length() < 32) {
                hashtext = "0" + hashtext;
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
        }
        return hashtext;
    }

    public static Date oneExtraYear(Date currentDate) {
        Calendar cal = Calendar.getInstance();
        cal.add(1, 1);
        Date nextYear = cal.getTime();
        return nextYear;
    }

    public static Date previousYear(Date currentDate) {
        Calendar cal = Calendar.getInstance();
        cal.add(1, -1);
        Date nextYear = cal.getTime();
        return nextYear;
    }
}

