/*
 * Decompiled with CFR 0.152.
 */
package com.forsedi.update;

import com.forsedi.update.model.Control;
import com.forsedi.update.util.Util;
import com.forsedi.update.util.UtilsFiles;
import com.forsedi.update.util.UtilsUpdate;
import com.forsedi.update.vista.FrameCarga;
import com.forsedi.update.ws.UpdateService;
import com.forsedi.update.ws.model.Response_Update;
import com.forsedi.update.ws.model.Response_Update_ListConfiguration;
import forsedi.criptografia.Checksum;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.FileUtils;

public class Update {
    private final FrameCarga frame;
    private Response_Update responseUpdates;
    private List<Response_Update_ListConfiguration> listUpdates;
    private List<Response_Update_ListConfiguration> pendingUpdates;
    private final List<String> errores;
    private Control control;
    private boolean verUpdates = false;
    private boolean aceptarUpdates = false;
    private boolean successDownload = false;
    private boolean successBackup = false;
    private boolean successReplace = false;
    private boolean successRollback = false;
    private final Date date = new Date();
    private final String id_installation;
    private final String urlUpdates;
    private final int updateBinaries;
    private final int updateConfig;
    private final int updateDesign;
    public File updateFolder;
    public File backupFolder;

    public Update(String id_installation, Properties properties, FrameCarga frameCarga) {
        this.frame = frameCarga;
        this.id_installation = id_installation;
        this.urlUpdates = "https://forsedi.facturacfdi.mx/";
        this.updateBinaries = UtilsUpdate.propToInt(properties.getProperty("UPDATE_BINARIES"));
        this.updateConfig = UtilsUpdate.propToInt(properties.getProperty("UPDATE_CONFIG"));
        this.updateDesign = UtilsUpdate.propToInt(properties.getProperty("UPDATE_DESIGNS"));
        this.listUpdates = new ArrayList<Response_Update_ListConfiguration>();
        this.pendingUpdates = new ArrayList<Response_Update_ListConfiguration>();
        this.errores = new ArrayList<String>();
    }

    public boolean checkPendingUpdates() throws Exception {
        try {
            this.responseUpdates = UpdateService.checkUpdates(this.urlUpdates, this.id_installation);
            if (!Util.isEmpty(this.responseUpdates.getError())) {
                this.errores.add(this.responseUpdates.getError());
            } else {
                this.listUpdates = this.responseUpdates.getListConfigurations();
                this.control = UtilsUpdate.loadControlVersion(this.id_installation);
                if (this.listUpdates != null) {
                    for (Response_Update_ListConfiguration newUpdate : this.listUpdates) {
                        if (newUpdate.getFilename().equals("Binaries.zip")) {
                            if (this.updateBinaries == 0 || Util.strToDate(this.control.getLastUpdateBinaries()).getTime() >= Util.strToDate(newUpdate.getReleaseDate(), "yyyy-MM-dd hh:mm:ss").getTime()) continue;
                            Date date = new Date();
                            String binChecksum = Checksum.getChecksum("ForsediV33.jar");
                            if (Util.isEmpty(binChecksum) || Util.isEmpty(newUpdate.getChecksum()) || !newUpdate.getChecksum().equals(binChecksum)) {
                                this.pendingUpdates.add(newUpdate);
                            }
                            Util.printTimeLapse(date, "Checksum: ");
                            continue;
                        }
                        if (newUpdate.getFilename().equals("Configuration.zip")) {
                            if (this.updateConfig == 0 || Util.strToDate(this.control.getLastUpdateConfig()).getTime() >= Util.strToDate(newUpdate.getReleaseDate(), "yyyy-MM-dd hh:mm:ss").getTime()) continue;
                            this.pendingUpdates.add(newUpdate);
                            continue;
                        }
                        if (!newUpdate.getFilename().equals("Designs.zip") || this.updateDesign == 0 || Util.strToDate(this.control.getLastUpdateConfig()).getTime() >= Util.strToDate(newUpdate.getReleaseDate(), "yyyy-MM-dd hh:mm:ss").getTime()) continue;
                        this.pendingUpdates.add(newUpdate);
                    }
                }
                if (this.pendingUpdates.size() > 0) {
                    return true;
                }
            }
        }
        catch (Exception ex) {
            this.pendingUpdates = new ArrayList<Response_Update_ListConfiguration>();
            this.frame.printTextArea("Error consultando las actualizacion del Conector Forsedi");
            this.frame.printTextArea(ex.getMessage());
        }
        return false;
    }

    public boolean backup() {
        this.successBackup = true;
        this.frame.printTextArea("Realizando respaldo:");
        String b1 = "Backups/temp_" + Util.dateToStr(this.date, "yyyy-MM-dd_hhmmss");
        this.backupFolder = new File(b1);
        this.frame.printTextArea("Carpeta de respaldo " + b1);
        if (!this.backupFolder.exists()) {
            this.backupFolder.mkdirs();
        }
        this.frame.printTextArea("Respaldando ejecutables...");
        for (Response_Update_ListConfiguration newUpdate : this.pendingUpdates) {
            try {
                if (!newUpdate.getFilename().equals("Binaries.zip")) continue;
                File fileJar = new File("ForsediV33.jar");
                if (UtilsFiles.backupFile(fileJar, this.backupFolder.getAbsolutePath())) {
                    File fileLib = new File("lib");
                    if (!UtilsFiles.backupFile(fileLib, this.backupFolder.getAbsolutePath())) {
                        throw new Exception();
                    }
                    break;
                }
                throw new Exception();
            }
            catch (Exception ex) {
                Logger.getLogger(Update.class.getName()).log(Level.SEVERE, null, ex);
                this.errores.add("No se pudo realizar el respaldo para " + newUpdate.getFilename());
                this.successBackup = false;
                return this.successBackup;
            }
        }
        this.frame.printTextArea("Respaldando configuracion y dise\u00f1os...");
        for (Response_Update_ListConfiguration newUpdate : this.pendingUpdates) {
            try {
                if (!newUpdate.getFilename().equals("Configuration.zip") && !newUpdate.getFilename().startsWith("disenio")) continue;
                File fileConfig = new File("ConfigurationFiles_CFD/");
                if (!UtilsFiles.backupFile(fileConfig, this.backupFolder.getAbsolutePath())) {
                    throw new Exception();
                }
                break;
            }
            catch (Exception ex) {
                Logger.getLogger(Update.class.getName()).log(Level.SEVERE, null, ex);
                this.errores.add("No se pudo realizar el respaldo para " + newUpdate.getFilename());
                this.successBackup = false;
                return this.successBackup;
            }
        }
        return this.successBackup;
    }

    public boolean downloadUpdates() {
        this.successDownload = true;
        this.frame.printTextArea("Iniciando descarga de archivos:");
        String b1 = "Updates/temp_" + Util.dateToStr(this.date, "yyyy-MM-dd_hhmmss");
        this.updateFolder = new File(b1);
        this.frame.printTextArea("Carpeta de descarga " + b1);
        if (!this.updateFolder.exists()) {
            this.updateFolder.mkdirs();
        }
        for (Response_Update_ListConfiguration newUpdate : this.pendingUpdates) {
            try {
                this.frame.printTextArea("Descargando " + newUpdate.getFilename() + "...");
                File file = new File(this.updateFolder + "/" + newUpdate.getFilename());
                FileUtils.copyURLToFile(new URL(newUpdate.getPathDownload()), file);
            }
            catch (Exception ex) {
                Logger.getLogger(Update.class.getName()).log(Level.SEVERE, null, ex);
                this.errores.add("No se pud\u00f3 realizar la descarga de " + newUpdate.getFilename());
                this.successDownload = false;
                break;
            }
        }
        return this.successDownload;
    }

    public boolean replaceFiles() {
        this.successReplace = true;
        this.frame.printTextArea("Remplazando archivos...");
        for (Response_Update_ListConfiguration newUpdate : this.pendingUpdates) {
            File[] files;
            File newFolder;
            ZipFile zipFile;
            if (newUpdate.getFilename().equals("Binaries.zip")) {
                File fileJar = new File("ForsediV33.jar");
                File fileLib = new File("lib");
                fileJar.delete();
                try {
                    ZipFile zipFile2 = new ZipFile(this.updateFolder.getAbsolutePath() + "/" + "Binaries.zip");
                    zipFile2.extractAll(this.updateFolder.getAbsolutePath());
                    UtilsFiles.replaceFile(fileJar, new File(this.updateFolder.getAbsolutePath() + "/" + "ForsediV33.jar"));
                    UtilsFiles.replaceFile(fileLib, new File(this.updateFolder.getAbsolutePath() + "/" + "lib"));
                    continue;
                }
                catch (ZipException ex) {
                    Logger.getLogger(Update.class.getName()).log(Level.SEVERE, null, ex);
                    this.errores.add("No se pudo descomprimir el archivo " + this.updateFolder.getAbsolutePath() + "/" + "Binaries.zip" + " en el directorio " + new File(".").getAbsolutePath());
                    break;
                }
                catch (IOException ex) {
                    Logger.getLogger(Update.class.getName()).log(Level.SEVERE, null, ex);
                    this.errores.add("Error remplazando los archivos binarios durante la actualizaci\u00f3n");
                    continue;
                }
            }
            if (newUpdate.getFilename().equals("Configuration.zip")) {
                try {
                    zipFile = new ZipFile(this.updateFolder.getAbsolutePath() + "/" + "Configuration.zip");
                    zipFile.extractAll(this.updateFolder.getAbsolutePath() + "/configuration");
                    newFolder = new File(this.updateFolder.getAbsolutePath() + "/configuration/ConfigurationFiles_CFD");
                    block16: for (File f : files = newFolder.listFiles()) {
                        if (f.isDirectory()) {
                            switch (f.getName()) {
                                case "empresas": {
                                    File[] emisores;
                                    for (File newEmisor : emisores = f.listFiles()) {
                                        if (!newEmisor.getName().equals("emisor.properties")) continue;
                                        File oldEmisores = new File("ConfigurationFiles_CFD/empresas/");
                                        for (File oldEmisor : oldEmisores.listFiles()) {
                                            if (!oldEmisor.getName().endsWith(".properties")) continue;
                                            UtilsUpdate.updateProperties(newEmisor.getAbsolutePath(), oldEmisor.getAbsolutePath());
                                        }
                                        continue block16;
                                    }
                                    break;
                                }
                            }
                            continue;
                        }
                        if (f.getName().equals("configuracion.properties")) {
                            UtilsUpdate.updateProperties(f.getAbsolutePath(), "ConfigurationFiles_CFD/configuracion.properties");
                            continue;
                        }
                        if (!f.getName().equals("log4j.xml")) continue;
                        UtilsFiles.replaceFile(new File("ConfigurationFiles_CFD/" + f.getName()), f);
                    }
                    continue;
                }
                catch (ZipException ex) {
                    Logger.getLogger(Update.class.getName()).log(Level.SEVERE, null, ex);
                    this.errores.add("No se pudo descomprimir el archivo " + this.updateFolder.getAbsolutePath() + "/" + "Configuration.zip" + " en el directorio " + this.updateFolder.getAbsolutePath() + "/configuration");
                    break;
                }
                catch (Exception ex) {
                    Logger.getLogger(Update.class.getName()).log(Level.SEVERE, null, ex);
                    this.errores.add("Error remplazando los archivos de configuraci\u00f3n durante la actualizaci\u00f3n");
                    break;
                }
            }
            if (!newUpdate.getFilename().equals("Designs.zip")) continue;
            try {
                zipFile = new ZipFile(this.updateFolder.getAbsolutePath() + "/" + newUpdate.getFilename());
                zipFile.extractAll(this.updateFolder.getAbsolutePath() + "/designs");
                newFolder = new File(this.updateFolder.getAbsolutePath() + "/designs");
                for (File f : files = newFolder.listFiles()) {
                    UtilsFiles.replaceFile(new File("ConfigurationFiles_CFD/XSL/" + f.getName()), f);
                }
            }
            catch (ZipException ex) {
                Logger.getLogger(Update.class.getName()).log(Level.SEVERE, null, ex);
                this.errores.add("No se pudo descomprimir el archivo " + this.updateFolder.getAbsolutePath() + "/" + newUpdate.getFilename() + " en el directorio " + this.updateFolder.getAbsolutePath() + "/designs");
                break;
            }
            catch (Exception ex) {
                Logger.getLogger(Update.class.getName()).log(Level.SEVERE, null, ex);
                this.errores.add("Error remplazando los archivos de dise\u00f1o durante la actualizaci\u00f3n");
                break;
            }
        }
        if (this.errores.size() > 0) {
            this.successReplace = false;
        }
        return this.successReplace;
    }

    public boolean rollback() {
        this.successRollback = true;
        this.frame.printTextArea("Realizando rollback...");
        if (this.backupFolder != null && this.backupFolder.exists()) {
            File fileConfig = new File(this.backupFolder.getAbsolutePath() + "/" + "ConfigurationFiles_CFD/");
            try {
                File fileLib;
                File fileJar;
                if (fileConfig.exists()) {
                    UtilsFiles.replaceFile(new File("ConfigurationFiles_CFD/"), fileConfig);
                }
                if ((fileJar = new File(this.backupFolder.getAbsolutePath() + "/" + "ForsediV33.jar")).exists()) {
                    UtilsFiles.replaceFile(new File("ForsediV33.jar"), fileJar);
                }
                if ((fileLib = new File(this.backupFolder.getAbsolutePath() + "/" + "lib")).exists()) {
                    UtilsFiles.replaceFile(new File("lib"), fileLib);
                }
            }
            catch (IOException ex) {
                this.successRollback = false;
                Logger.getLogger(Update.class.getName()).log(Level.SEVERE, null, ex);
                this.errores.add("Error realizando el rollback desde " + this.backupFolder.getAbsolutePath() + "\n" + ex.getMessage());
            }
        }
        return this.successRollback;
    }

    public void close() {
        if (this.errores.size() > 0) {
            this.errores.add("Rollback: " + this.rollback());
            this.errores.forEach(err -> this.frame.printTextArea((String)err));
        }
        try {
            UtilsUpdate.updateControlVersion(this.control, this.errores, this.pendingUpdates, this.backupFolder);
        }
        catch (JAXBException ex) {
            Logger.getLogger(Update.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.updateFolder != null && this.updateFolder.exists()) {
            UtilsFiles.deleteFolder(this.updateFolder);
        }
        if (this.aceptarUpdates && this.pendingUpdates.size() > 0 || this.errores.size() > 0) {
            UpdateService.sendUpdateSuccess(this.urlUpdates, this.errores, this.pendingUpdates, this.id_installation, this.responseUpdates.getActualDate());
        }
    }

    public String getId_installation() {
        return this.id_installation;
    }

    public String getUrlUpdates() {
        return this.urlUpdates;
    }

    public boolean isVerUpdates() {
        return this.verUpdates;
    }

    public void setVerUpdates(boolean verUpdates) {
        this.verUpdates = verUpdates;
    }

    public boolean getAceptarUpdates() {
        return this.aceptarUpdates;
    }

    public void setAceptarUpdates(boolean aceptarUpdates) {
        this.aceptarUpdates = aceptarUpdates;
    }

    public List<Response_Update_ListConfiguration> getListUpdates() {
        return this.listUpdates;
    }

    public Response_Update getResponseUpdates() {
        return this.responseUpdates;
    }

    public void setListUpdates(List<Response_Update_ListConfiguration> listUpdates) {
        this.listUpdates = listUpdates;
    }

    public List<Response_Update_ListConfiguration> getPendingUpdates() {
        return this.pendingUpdates;
    }

    public void setPendingUpdates(List<Response_Update_ListConfiguration> pendingUpdates) {
        this.pendingUpdates = pendingUpdates;
    }

    public List<String> getErrores() {
        return this.errores;
    }

    public Control getControl() {
        return this.control;
    }

    public void setControl(Control control) {
        this.control = control;
    }

    public boolean isSuccessDownload() {
        return this.successDownload;
    }

    public void setSuccessDownload(boolean successDownload) {
        this.successDownload = successDownload;
    }

    public boolean isSuccessBackup() {
        return this.successBackup;
    }

    public void setSuccessBackup(boolean successBackup) {
        this.successBackup = successBackup;
    }

    public boolean isSuccessReplace() {
        return this.successReplace;
    }

    public void setSuccessReplace(boolean successReplace) {
        this.successReplace = successReplace;
    }

    public boolean isSuccessRollback() {
        return this.successRollback;
    }

    public void setSuccessRollback(boolean successRollback) {
        this.successRollback = successRollback;
    }

    public int getUpdateBinaries() {
        return this.updateBinaries;
    }

    public int getUpdateConfig() {
        return this.updateConfig;
    }

    public int getUpdateDesign() {
        return this.updateDesign;
    }
}

