/*
 * Decompiled with CFR 0.152.
 */
package com.forsedi.update;

import com.forsedi.update.Update;
import com.forsedi.update.model.Control;
import com.forsedi.update.util.Util;
import com.forsedi.update.util.UtilsFiles;
import com.forsedi.update.util.UtilsUpdate;
import com.forsedi.update.vista.DialogInstall;
import com.forsedi.update.vista.DialogUpdatePreview;
import com.forsedi.update.vista.FrameCarga;
import com.forsedi.update.ws.UpdateService;
import java.awt.Frame;
import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.lingala.zip4j.core.ZipFile;
import org.apache.commons.io.FileUtils;

public class Main {
    public static void main(String[] args) {
        FrameCarga frame;
        block16: {
            frame = new FrameCarga();
            try {
                if (UtilsUpdate.isRunningConector()) break block16;
                if (!UtilsUpdate.isInstalled()) {
                    Update update = new Update("", new Properties(), frame);
                    DialogInstall dialogInstall = new DialogInstall((Frame)frame, true, update);
                    dialogInstall.setLocationRelativeTo(null);
                    dialogInstall.setVisible(true);
                    if (update.getAceptarUpdates()) {
                        Main.installConector(frame);
                        UpdateService.sendRegistration();
                    }
                    break block16;
                }
                UpdateService.addURL();
                frame.setTitle("Actualizar Conector Forsedi V33");
                frame.getLabelTitle().setText("Actualizar Conector Forsedi V33");
                frame.setVisible(true);
                Properties conectorProperties = UtilsFiles.loadProperties("ConfigurationFiles_CFD/configuracion.properties");
                Properties updateProperties = new Properties();
                updateProperties.setProperty("UPDATE_BINARIES", conectorProperties.getProperty("UPDATE_BINARIES"));
                updateProperties.setProperty("UPDATE_CONFIG", conectorProperties.getProperty("UPDATE_CONFIG"));
                updateProperties.setProperty("UPDATE_DESIGNS", conectorProperties.getProperty("UPDATE_DESIGNS"));
                updateProperties.setProperty("URL_UPDATES", "https://forsedi.facturacfdi.mx/");
                Update update = new Update(UtilsUpdate.getMachineID(), updateProperties, frame);
                try {
                    if (update.getUpdateBinaries() != 0 || update.getUpdateConfig() != 0 || update.getUpdateDesign() != 0) {
                        frame.printTextArea("Verificando la configuraci\u00f3n actual, espere...");
                        UpdateService.sendRegistration();
                        update.checkPendingUpdates();
                    }
                    if (update.getPendingUpdates().size() > 0) {
                        if (update.getUpdateBinaries() != 2 || update.getUpdateConfig() != 2 || update.getUpdateDesign() != 2) {
                            DialogUpdatePreview dialogUpdatePreview = new DialogUpdatePreview((Frame)frame, true, update);
                            dialogUpdatePreview.setLocationRelativeTo(null);
                            dialogUpdatePreview.setVisible(true);
                        }
                        if (update.getAceptarUpdates()) {
                            if (update.downloadUpdates() && update.backup() && update.replaceFiles()) {
                                UpdateService.sendRegistration();
                                frame.printTextArea("Actualizacion realizada");
                            }
                            update.close();
                        }
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(Update.class.getName()).log(Level.SEVERE, null, ex);
                    update.getErrores().add(ex.getMessage());
                }
                if (update.getPendingUpdates().isEmpty() && update.getErrores().isEmpty()) {
                    UpdateService.sendUpdateSuccess(update);
                }
                for (String err : update.getErrores()) {
                    frame.printTextArea(err);
                }
                if (update.getErrores().isEmpty()) {
                    frame.printTextArea("Proceso terminado");
                }
            }
            catch (Exception ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex1) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex1);
                }
            }
        }
        frame.dispose();
        System.exit(0);
    }

    private static void installConector(FrameCarga frame) throws Exception {
        frame.setTitle("Instalador Conector Forsedi V33");
        frame.getLabelTitle().setText("Instalador Conector Forsedi V33");
        frame.setVisible(true);
        Date date = new Date();
        File updateFolder = new File("Updates/temp_" + Util.dateToStr(date, "yyyy-MM-dd_hhmmss"));
        if (!updateFolder.exists()) {
            updateFolder.mkdirs();
        }
        frame.printTextArea("Iniciando descarga de archivos:");
        frame.printTextArea("Descargando Configuration.zip...");
        Main.download(updateFolder, "Configuration.zip");
        frame.printTextArea("Descargando Designs.zip...");
        Main.download(updateFolder, "Designs.zip");
        frame.printTextArea("Descargando Binaries.zip...");
        Main.download(updateFolder, "Binaries.zip");
        frame.printTextArea("Extraer ejecutable...");
        ZipFile zipFile = new ZipFile(updateFolder.getAbsolutePath() + "/" + "Binaries.zip");
        zipFile.extractAll(updateFolder.getAbsolutePath());
        UtilsFiles.replaceFile(new File("ForsediV33.jar"), new File(updateFolder.getAbsolutePath() + "/" + "ForsediV33.jar"));
        UtilsFiles.replaceFile(new File("lib"), new File(updateFolder.getAbsolutePath() + "/" + "lib"));
        frame.printTextArea("Extraer configuracion generica...");
        zipFile = new ZipFile(updateFolder.getAbsolutePath() + "/" + "Configuration.zip");
        zipFile.extractAll(updateFolder.getAbsolutePath());
        UtilsFiles.replaceFile(new File("ConfigurationFiles_CFD/"), new File(updateFolder.getAbsolutePath() + "/" + "ConfigurationFiles_CFD/"));
        frame.printTextArea("Extraer dise\u00f1os pdf genericos...");
        zipFile = new ZipFile(updateFolder.getAbsolutePath() + "/" + "Designs.zip");
        zipFile.extractAll(updateFolder.getAbsolutePath() + "/" + "ConfigurationFiles_CFD/XSL/");
        UtilsFiles.replaceFile(new File("ConfigurationFiles_CFD/XSL/"), new File(updateFolder.getAbsolutePath() + "/" + "ConfigurationFiles_CFD/XSL/"));
        Control control = UtilsUpdate.loadControlVersion("");
        control.setLastUpdateBinaries(Util.dateToStr(new Date(), "yyyy-MM-dd hh:mm:ss"));
        control.setLastUpdateConfig(Util.dateToStr(new Date(), "yyyy-MM-dd hh:mm:ss"));
        UtilsUpdate.saveControlVersion(control);
        frame.printTextArea("Se guard\u00f3 el log de control de version...");
        frame.printTextArea("Instalaci\u00f3n Terminada");
    }

    private static void download(File folder, String name) throws Exception {
        File file = new File(folder + "/" + name);
        String url = "https://s3-us-west-2.amazonaws.com/updateconectores/Release/" + name;
        try {
            FileUtils.copyURLToFile(new URL(url), file);
        }
        catch (Exception ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            throw new Exception("No se pudo descargar " + url);
        }
    }
}

