/*
 * Decompiled with CFR 0.152.
 */
package com.formas.aws.dynamodb;

import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.formas.aws.dynamodb.Dao;
import com.formas.aws.dynamodb.domain.Tbl_cfdi;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class Init {
    public static void main(String[] args) {
        Init init = new Init();
        init.addItemsCatalogos();
    }

    private void pruebas() {
        HashMap<String, String> attributeNames = new HashMap<String, String>();
        attributeNames.put("#dtfechatimbrado", "dtfechatimbrado");
        HashMap<String, AttributeValue> attributeValues = new HashMap<String, AttributeValue>();
        attributeValues.put(":from", new AttributeValue().withS("2018-06-05 12:00:00.000"));
        ScanRequest scanRequest = new ScanRequest().withTableName("TBL_CFDI").withFilterExpression("#dtfechatimbrado > :from").withExpressionAttributeNames(attributeNames).withExpressionAttributeValues(attributeValues);
        Dao dao = new Dao(false);
        LinkedList<Tbl_cfdi> lres = dao.executeQuery(Tbl_cfdi.class, scanRequest);
        lres.forEach(item -> System.out.println("UUID:\t" + item.getVchSello()));
    }

    private void createTables() {
        Dao dao = new Dao(false);
        dao.createTable("C_CLAVEPRODSERV", 100L, 100L, "CLAVE", "S");
    }

    private void updateProvisionedThroughput() {
        Dao dao = new Dao(false);
        dao.updateProvisionedThroughput("C_CLAVEPRODSERV", 5L, 5L);
    }

    private void deleteTable() {
        Dao dao = new Dao(false);
        dao.deleteTable("C_CLAVEPRODSERV");
    }

    private void addItems() {
        Dao dao = new Dao(false);
        ArrayList<Item> listadoItems = new ArrayList<Item>();
        listadoItems.add(new Item().withPrimaryKey("CLAVE", (Object)"10101807").withString("DESCRIPCION", "Pulpo vivo").withString("IVA_TRASLADADO", "Opcional").withString("IEPS_TRASLADADO", "Opcional").withString("INICIO_VIGENCIA", "2017-08-14"));
        listadoItems.add(new Item().withPrimaryKey("CLAVE", (Object)"10101512").withString("DESCRIPCION", "Conejos").withString("IVA_TRASLADADO", "Opcional").withString("IEPS_TRASLADADO", "Opcional").withString("COMPLEMENTO", "TEST").withString("INICIO_VIGENCIA", "2017-08-14").withString("FIN_VIGENCIA", "TEST").withString("PALABRAS_SIMILARES", "Liebres"));
        dao.writeBatch("C_CLAVEPRODSERV", listadoItems);
    }

    private void addItemsClaveProdServ() {
        try {
            Dao dao = new Dao(false);
            ArrayList<Item> listadoItems = new ArrayList<Item>();
            Path path = Paths.get("C:\\temp\\XXX\\catalogossat\\claveprodserv.txt", new String[0]);
            Stream<String> lines = Files.lines(path);
            lines.forEach(line -> {
                String[] data = Init.getStringToArray(line, '|');
                try {
                    Item item = new Item().withPrimaryKey("CLAVE", (Object)data[0]);
                    if (!data[1].isEmpty()) {
                        item.withString("DESCRIPCION", data[1]);
                    }
                    if (!data[2].isEmpty()) {
                        item.withString("IVA_TRASLADADO", data[2]);
                    }
                    if (!data[3].isEmpty()) {
                        item.withString("IEPS_TRASLADADO", data[3]);
                    }
                    if (!data[4].isEmpty()) {
                        item.withString("COMPLEMENTO", data[4]);
                    }
                    if (!data[5].isEmpty()) {
                        item.withString("INICIO_VIGENCIA", data[5]);
                    }
                    if (!data[6].isEmpty()) {
                        item.withString("FIN_VIGENCIA", data[6]);
                    }
                    if (!data[7].isEmpty()) {
                        item.withString("PALABRAS_SIMILARES", data[7]);
                    }
                    listadoItems.add(item);
                    if (listadoItems.size() == 25) {
                        dao.writeBatch("C_CLAVEPRODSERV", listadoItems);
                        listadoItems.clear();
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("data::: " + line);
                    e.printStackTrace();
                }
            });
            lines.close();
            if (listadoItems.size() > 0) {
                dao.writeBatch("C_CLAVEPRODSERV", listadoItems);
                listadoItems.clear();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Init.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void addItemsCatalogos() {
        try {
            Dao dao = new Dao(false);
            ArrayList listadoItems = new ArrayList();
            LinkedList headersItems = new LinkedList();
            LinkedList autoincrementList = new LinkedList();
            Files.list(Paths.get("C:\\temp\\XXX\\catalogossat", new String[0])).forEach(path -> {
                try {
                    listadoItems.clear();
                    headersItems.clear();
                    autoincrementList.clear();
                    String nombreArchivo = path.getFileName().toString();
                    nombreArchivo = nombreArchivo.substring(0, nombreArchivo.indexOf(".")) + "-";
                    String[] tableProp = Init.getStringToArray(nombreArchivo, '-');
                    String nombreTable = tableProp[0];
                    String campoPK = tableProp[1];
                    String typeDataPK = tableProp[2];
                    dao.updateProvisionedThroughput(nombreTable, 200L, 200L);
                    dao.deleteTable(nombreTable);
                    dao.createTable(nombreTable, 200L, 200L, campoPK, typeDataPK);
                    Thread.sleep(10000L);
                    Stream<String> lines = Files.lines(path);
                    lines.forEach(line -> {
                        if (campoPK.equals("AUTOINCREMENTO")) {
                            line = headersItems.isEmpty() ? "AUTOINCREMENTO|" + line : autoincrementList.size() + "|" + line;
                        }
                        String[] data = Init.getStringToArray(line, '|');
                        try {
                            if (headersItems.isEmpty()) {
                                headersItems.addAll(Arrays.asList(data));
                            } else {
                                Item item = new Item();
                                for (int index = 0; index < headersItems.size(); ++index) {
                                    if (data[index].isEmpty()) continue;
                                    item.withString((String)headersItems.get(index), data[index]);
                                }
                                listadoItems.add(item);
                                autoincrementList.add(autoincrementList.size() + 1);
                                if (listadoItems.size() == 25) {
                                    dao.writeBatch(nombreTable, listadoItems);
                                    listadoItems.clear();
                                }
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            System.out.println("data::: " + line);
                            e.printStackTrace();
                        }
                    });
                    lines.close();
                    if (listadoItems.size() > 0) {
                        dao.writeBatch(nombreTable, listadoItems);
                        listadoItems.clear();
                    }
                    dao.updateProvisionedThroughput(nombreTable, 5L, 5L);
                    System.out.println(path.getFileName().toString());
                }
                catch (Exception ex) {
                    Logger.getLogger(Init.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
        }
        catch (IOException ex) {
            Logger.getLogger(Init.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static String[] getStringToArray(String cadena, char delimitador) {
        cadena = cadena.trim().substring(0, cadena.trim().length() - 1);
        int conPipe = 0;
        int inicio = 0;
        int indexPipe = cadena.indexOf(delimitador);
        boolean ban = false;
        int contador = 0;
        String[] arr = new String[]{};
        do {
            if (indexPipe == -1) {
                ban = true;
                if (cadena.length() != inicio) {
                    arr = (String[])Init.resizeArray(arr, arr.length + 1);
                    arr[conPipe] = cadena.substring(inicio, cadena.length());
                } else {
                    arr = (String[])Init.resizeArray(arr, arr.length + 1);
                    arr[conPipe] = "";
                }
            } else if (inicio != 0 || indexPipe != 0) {
                arr = (String[])Init.resizeArray(arr, arr.length + 1);
                arr[conPipe] = cadena.substring(inicio, indexPipe);
                ++conPipe;
            } else {
                arr = (String[])Init.resizeArray(arr, arr.length + 1);
                arr[conPipe] = "";
                ++conPipe;
            }
            inicio = indexPipe + 1;
            indexPipe = cadena.indexOf(delimitador, inicio);
            ++contador;
        } while (inicio == indexPipe || !ban);
        return arr;
    }

    public static Object resizeArray(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }
}

