/*
 * Decompiled with CFR 0.152.
 */
package com.formas.aws.dynamodb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.document.BatchWriteItemOutcome;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.TableWriteItems;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.formas.aws.dynamodb.DynamoCliente;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Dao {
    boolean isproduccion;

    public Dao(boolean isproduccion) {
        this.isproduccion = isproduccion;
    }

    public <T> LinkedList<T> executeQuery(Class<T> t, ScanRequest scanRequest) {
        DynamoCliente dynamocliente = new DynamoCliente();
        AmazonDynamoDB dynamodb = dynamocliente.getClient(this.isproduccion);
        DynamoDBMapper mapper = new DynamoDBMapper(dynamodb);
        ScanResult result = dynamodb.scan(scanRequest);
        LinkedList lresult = new LinkedList();
        result.getItems().forEach(item -> lresult.add(mapper.marshallIntoObject(t, item)));
        return lresult;
    }

    public void saveItem(Item item, String tablename) {
        DynamoCliente dynamocliente = new DynamoCliente();
        AmazonDynamoDB dynamoclientdb = dynamocliente.getClient(this.isproduccion);
        DynamoDB dynamoDB = new DynamoDB(dynamoclientdb);
        Table table = dynamoDB.getTable(tablename);
        table.putItem(item);
    }

    public void deleteTable(String tableName) {
        DynamoCliente dynamocliente = new DynamoCliente();
        AmazonDynamoDB dynamoclientdb = dynamocliente.getClient(this.isproduccion);
        DynamoDB dynamoDB = new DynamoDB(dynamoclientdb);
        Table table = dynamoDB.getTable(tableName);
        try {
            System.out.println("Issuing DeleteTable request for " + tableName);
            table.delete();
            System.out.println("Waiting for " + tableName + " to be deleted...this may take a while...");
            table.waitForDelete();
        }
        catch (Exception e) {
            System.err.println("DeleteTable request failed for " + tableName);
            System.err.println(e.getMessage());
        }
    }

    public void createTable(String tableName, long readCapacityUnits, long writeCapacityUnits, String partitionKeyName, String partitionKeyType) {
        this.createTable(tableName, readCapacityUnits, writeCapacityUnits, partitionKeyName, partitionKeyType, null, null);
    }

    public void createTable(String tableName, long readCapacityUnits, long writeCapacityUnits, String partitionKeyName, String partitionKeyType, String sortKeyName, String sortKeyType) {
        try {
            DynamoCliente dynamocliente = new DynamoCliente();
            AmazonDynamoDB dynamoclientdb = dynamocliente.getClient(this.isproduccion);
            ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>();
            keySchema.add(new KeySchemaElement().withAttributeName(partitionKeyName).withKeyType(KeyType.HASH));
            ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
            attributeDefinitions.add(new AttributeDefinition().withAttributeName(partitionKeyName).withAttributeType(partitionKeyType));
            if (sortKeyName != null) {
                keySchema.add(new KeySchemaElement().withAttributeName(sortKeyName).withKeyType(KeyType.RANGE));
                attributeDefinitions.add(new AttributeDefinition().withAttributeName(sortKeyName).withAttributeType(sortKeyType));
            }
            CreateTableRequest request = new CreateTableRequest().withTableName(tableName).withKeySchema(keySchema).withProvisionedThroughput(new ProvisionedThroughput().withReadCapacityUnits(Long.valueOf(readCapacityUnits)).withWriteCapacityUnits(Long.valueOf(writeCapacityUnits)));
            request.setAttributeDefinitions(attributeDefinitions);
            System.out.println("Issuing CreateTable request for " + tableName);
            CreateTableResult tableRes = dynamoclientdb.createTable(request);
            System.out.println("Waiting for " + tableName + " to be created...this may take a while..." + tableRes.toString());
        }
        catch (Exception e) {
            System.err.println("CreateTable request failed for " + tableName);
            System.err.println(e.getMessage());
        }
    }

    public void updateProvisionedThroughput(String tableName, long readCapacityUnits, long writeCapacityUnits) {
        DynamoCliente dynamocliente = new DynamoCliente();
        AmazonDynamoDB dynamoclientdb = dynamocliente.getClient(this.isproduccion);
        DynamoDB dynamoDB = new DynamoDB(dynamoclientdb);
        Table table = dynamoDB.getTable(tableName);
        try {
            table.updateTable(new ProvisionedThroughput().withReadCapacityUnits(Long.valueOf(readCapacityUnits)).withWriteCapacityUnits(Long.valueOf(writeCapacityUnits)));
            table.waitForActive();
        }
        catch (Exception e) {
            System.err.println("UpdateTable request failed for " + tableName);
            System.err.println(e.getMessage());
        }
    }

    public void writeBatch(String tableName, List<Item> listaItems) {
        DynamoCliente dynamocliente = new DynamoCliente();
        AmazonDynamoDB dynamoclientdb = dynamocliente.getClient(this.isproduccion);
        DynamoDB dynamoDB = new DynamoDB(dynamoclientdb);
        TableWriteItems forumTableWriteItems = new TableWriteItems(tableName).withItemsToPut(listaItems);
        BatchWriteItemOutcome outcome = dynamoDB.batchWriteItem(new TableWriteItems[]{forumTableWriteItems});
        do {
            Map unprocessedItems = outcome.getUnprocessedItems();
            if (outcome.getUnprocessedItems().size() == 0) {
                System.out.println("No unprocessed items found");
                continue;
            }
            System.out.println("Retrieving the unprocessed items");
            outcome = dynamoDB.batchWriteItemUnprocessed(unprocessedItems);
        } while (outcome.getUnprocessedItems().size() > 0);
    }
}

