/*
 * Decompiled with CFR 0.152.
 */
package com.formas.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.HttpMethod;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.formas.bean.Bucket;
import com.formas.bean.FiletoUpload;
import com.formas.exceptions.ClienteS3Exception;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;

public class UploadFile {
    private static final String CONTENT_TYPE = "text/xml";
    private final AWSCredentials credentials;
    private final AmazonS3 s3client;
    private final Bucket bucket;

    public UploadFile(Bucket bucket) {
        this.bucket = bucket;
        this.credentials = new BasicAWSCredentials(bucket.getAccesskeyid(), bucket.getSecretaccesskey());
        this.s3client = new AmazonS3Client(this.credentials);
    }

    public synchronized String uploadFile(FiletoUpload fileUpload) throws ClienteS3Exception {
        try {
            File file = new File(fileUpload.getFullPathFile());
            String pathToStore = fileUpload.getPathToStore() + "/" + fileUpload.getNameFile();
            this.s3client.putObject(new PutObjectRequest(this.bucket.getName(), pathToStore, file));
            return pathToStore;
        }
        catch (AmazonServiceException ase) {
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP Status Code: " + ase.getStatusCode());
            System.out.println("AWS Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            throw new ClienteS3Exception(ase);
        }
        catch (AmazonClientException ace) {
            throw new ClienteS3Exception(ace);
        }
    }

    public synchronized boolean uploadFileInputStream(String doctoAsString, String pathToStore) throws ClienteS3Exception {
        try {
            byte[] fileContentBytes = doctoAsString.getBytes(StandardCharsets.UTF_8);
            ByteArrayInputStream fileInputStream = new ByteArrayInputStream(fileContentBytes);
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentType(CONTENT_TYPE);
            metadata.setContentLength(fileContentBytes.length);
            PutObjectResult rs = this.s3client.putObject(new PutObjectRequest(this.bucket.getName(), pathToStore, fileInputStream, metadata));
            return rs != null;
        }
        catch (AmazonServiceException ase) {
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP Status Code: " + ase.getStatusCode());
            System.out.println("AWS Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            throw new ClienteS3Exception(ase);
        }
        catch (AmazonClientException ace) {
            throw new ClienteS3Exception(ace);
        }
    }

    public synchronized String uploadPublicZipFile(File fileToUpload, String pathToStore) throws ClienteS3Exception {
        try {
            this.s3client.putObject(new PutObjectRequest(this.bucket.getName(), pathToStore, fileToUpload).withCannedAcl(CannedAccessControlList.PublicRead));
            Date expiration = new Date();
            long milliSeconds = expiration.getTime();
            expiration.setTime(milliSeconds += 518400000L);
            String urlaux = pathToStore;
            GeneratePresignedUrlRequest generatePresignedUrlRequest = new GeneratePresignedUrlRequest(this.bucket.getName(), urlaux);
            generatePresignedUrlRequest.setMethod(HttpMethod.GET);
            generatePresignedUrlRequest.setExpiration(expiration);
            URL url = this.s3client.generatePresignedUrl(generatePresignedUrlRequest);
            return url.toString();
        }
        catch (AmazonServiceException ase) {
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP Status Code: " + ase.getStatusCode());
            System.out.println("AWS Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            throw new ClienteS3Exception(ase);
        }
        catch (AmazonClientException ace) {
            throw new ClienteS3Exception(ace);
        }
    }

    public synchronized Boolean uploadPublicZipFile(File fileToUpload, String pathToStore, boolean noURL) throws ClienteS3Exception {
        try {
            PutObjectResult rs = this.s3client.putObject(new PutObjectRequest(this.bucket.getName(), pathToStore, fileToUpload).withCannedAcl(CannedAccessControlList.PublicRead));
            return rs != null;
        }
        catch (AmazonServiceException ase) {
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP Status Code: " + ase.getStatusCode());
            System.out.println("AWS Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            throw new ClienteS3Exception(ase);
        }
        catch (AmazonClientException ace) {
            throw new ClienteS3Exception(ace);
        }
    }

    public synchronized boolean uploadPrivateZipFile(File fileToUpload, String pathToStore) throws ClienteS3Exception {
        try {
            PutObjectResult rs = this.s3client.putObject(new PutObjectRequest(this.bucket.getName(), pathToStore, fileToUpload).withCannedAcl(CannedAccessControlList.PublicRead));
            return rs != null;
        }
        catch (AmazonServiceException ase) {
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP Status Code: " + ase.getStatusCode());
            System.out.println("AWS Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            throw new ClienteS3Exception(ase);
        }
        catch (AmazonClientException ace) {
            throw new ClienteS3Exception(ace);
        }
    }
}

