/*
 * Decompiled with CFR 0.152.
 */
package com.formas.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.util.IOUtils;
import com.formas.bean.Bucket;
import com.formas.exceptions.ClienteS3Exception;
import java.io.IOException;
import java.net.ConnectException;

public class DownloadFileRetencionesS3 {
    private final AWSCredentials credentials;
    private final AmazonS3 s3client;
    private final Bucket bucket;

    public DownloadFileRetencionesS3(boolean isproduccion) {
        this.bucket = isproduccion ? new Bucket("retenciones", "AKIAJ4T4N7NNVJHENYPA", "+uHnWFiWxpDpsA4dZvchn18Vy55BYMkF/nVP7wH3") : new Bucket("retencionespruebas", "AKIAJXOJDSAXRLYDS2NA", "JpU3gX+nh5wfnp3MTHTu5HFtPkKM3VcfSfmPQAi1");
        this.credentials = new BasicAWSCredentials(this.bucket.getAccesskeyid(), this.bucket.getSecretaccesskey());
        this.s3client = new AmazonS3Client(this.credentials);
    }

    public synchronized String readFile(String objectkey) throws ClienteS3Exception {
        try {
            try {
                S3Object obj = this.s3client.getObject(new GetObjectRequest(this.bucket.getName(), objectkey));
                String outputText = IOUtils.toString(obj.getObjectContent());
                return outputText;
            }
            catch (ConnectException ex) {
                S3Object obj = this.s3client.getObject(new GetObjectRequest(this.bucket.getName(), objectkey));
                String outputText = IOUtils.toString(obj.getObjectContent());
                return outputText;
            }
        }
        catch (AmazonServiceException ase) {
            System.out.println("Error Message:    " + ase.getMessage());
            System.out.println("HTTP Status Code: " + ase.getStatusCode());
            System.out.println("AWS Error Code:   " + ase.getErrorCode());
            System.out.println("Error Type:       " + (Object)((Object)ase.getErrorType()));
            System.out.println("Request ID:       " + ase.getRequestId());
            throw new ClienteS3Exception(ase);
        }
        catch (AmazonClientException ace) {
            throw new ClienteS3Exception(ace);
        }
        catch (IOException ex) {
            throw new ClienteS3Exception(ex);
        }
    }
}

